/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.server;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ModLogger {
    private static final Marker MOD_MARKER = MarkerManager.getMarker((String)"bard_mania");
    private static Logger logger;

    public static void setLogger(Logger logger) {
        if (ModLogger.logger != null) {
            throw new IllegalStateException("Attempt to replace logger");
        }
        ModLogger.logger = logger;
    }

    public static void log(Level level, Marker marker, String format, Object ... data) {
        logger.printf(level, marker, format, data);
    }

    public static <T extends Throwable> void log(Level level, T e) {
        if (e != null) {
            ModLogger.log(level, MOD_MARKER, "%s", e.getLocalizedMessage());
            for (StackTraceElement s : e.getStackTrace()) {
                ModLogger.log(level, MOD_MARKER, "%s", s.toString());
            }
        }
    }

    public static void info(String format, Object ... data) {
        ModLogger.log(Level.INFO, MOD_MARKER, format, data);
    }

    public static void debug(String format, Object ... data) {
        ModLogger.log(Level.DEBUG, MOD_MARKER, format, data);
    }

    public static void warn(String format, Object ... data) {
        ModLogger.log(Level.WARN, MOD_MARKER, format, data);
    }

    public static void error(String format, Object ... data) {
        ModLogger.log(Level.ERROR, MOD_MARKER, format, data);
    }

    public static void fatal(String format, Object ... data) {
        ModLogger.log(Level.FATAL, MOD_MARKER, format, data);
    }

    public static <T extends Throwable> void info(T e) {
        ModLogger.log(Level.INFO, e);
    }

    public static <T extends Throwable> void debug(T e) {
        ModLogger.log(Level.DEBUG, e);
    }

    public static <T extends Throwable> void warn(T e) {
        ModLogger.log(Level.WARN, e);
    }

    public static <T extends Throwable> void error(T e) {
        ModLogger.log(Level.ERROR, e);
    }

    public static <T extends Throwable> void fatal(T e) {
        ModLogger.log(Level.FATAL, e);
    }
}

