/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.server.caps;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import net.aeronica.mods.bard_mania.BardMania;
import net.aeronica.mods.bard_mania.client.actions.base.ModelDummy;
import net.aeronica.mods.bard_mania.server.Util;
import net.aeronica.mods.bard_mania.server.caps.DimChangeMessage;
import net.aeronica.mods.bard_mania.server.caps.IBardAction;
import net.aeronica.mods.bard_mania.server.network.PacketDispatcher;
import net.aeronica.mods.bard_mania.server.network.bi.PoseActionMessage;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.relauncher.Side;

public class BardActionHelper {
    @CapabilityInject(value=IBardAction.class)
    private static final Capability<IBardAction> BARD_ACTION_CAP = (Capability)Util.nonNullInjected();
    private static List<DimChangeMessage> delayedDimChangeMessages = new CopyOnWriteArrayList<DimChangeMessage>();

    public static void setInstrumentEquipped(EntityPlayer player) {
        BardActionHelper.getImpl(player).setInstrumentEquipped();
        BardActionHelper.sendMessage(player, 1, false);
    }

    public static void setInstrumentRemoved(EntityPlayer player) {
        BardActionHelper.getImpl(player).setInstrumentRemoved();
        BardActionHelper.sendMessage(player, 2, false);
    }

    public static void setInstrumentRemovedByForce(EntityPlayer player) {
        BardActionHelper.getImpl(player).setInstrumentRemoved();
        BardActionHelper.sendMessage(player, 2, true);
    }

    public static ModelDummy getModelDummy(EntityPlayer player) {
        return BardActionHelper.getImpl(player).getModelDummy();
    }

    public static void updateOnJoin(EntityPlayer existingPlayer, EntityLivingBase joiningPlayer, boolean queue) {
        if (existingPlayer.func_145782_y() != joiningPlayer.func_145782_y()) {
            if (queue) {
                BardActionHelper.queueMessage(existingPlayer, 0, false);
            } else {
                BardActionHelper.sendMessage(existingPlayer, 0, false);
            }
        }
    }

    public static boolean isInstrumentEquipped(EntityPlayer player) {
        return BardActionHelper.getImpl(player).isInstrumentEquipped();
    }

    @Nullable
    private static IBardAction getImpl(EntityPlayer player) {
        if (!player.hasCapability(BARD_ACTION_CAP, null)) {
            throw new RuntimeException("IBardAction capability is null");
        }
        IBardAction bardActionImpl = (IBardAction)player.getCapability(BARD_ACTION_CAP, null);
        return bardActionImpl;
    }

    public static List<DimChangeMessage> getDimChangeMessages() {
        return delayedDimChangeMessages;
    }

    public static void queueMessage(EntityPlayer player, int action, boolean byForce) {
        Object message = null;
        if (BardMania.proxy.getEffectiveSide().equals((Object)Side.SERVER)) {
            delayedDimChangeMessages.add(new DimChangeMessage(new PoseActionMessage(player, action, byForce), player.func_130014_f_().field_73011_w.getDimension()));
        }
    }

    private static void sendMessage(EntityPlayer player, int action, boolean byForce) {
        if (BardMania.proxy.getEffectiveSide().equals((Object)Side.SERVER)) {
            PacketDispatcher.sendToDimension(new PoseActionMessage(player, action, byForce), player.func_130014_f_().field_73011_w.getDimension());
        }
    }
}

