/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.server.init;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.aeronica.mods.bard_mania.server.init.ModInstruments;
import net.aeronica.mods.bard_mania.server.item.ItemInstrument;
import net.aeronica.mods.bard_mania.server.object.Instrument;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="bard_mania")
public class ModSoundEvents {
    private static final Map<String, SoundEvent> SOUNDS = new HashMap<String, SoundEvent>();

    @Nullable
    private static SoundEvent registerSound(String soundName) {
        ResourceLocation soundID = new ResourceLocation(soundName);
        SoundEvent soundEvent = soundName.contains("bard_mania:") ? (SoundEvent)new SoundEvent(soundID).setRegistryName(soundID) : (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)soundID);
        return soundEvent;
    }

    public static SoundEvent getSound(String soundName) {
        return SOUNDS.getOrDefault(soundName, SoundEvents.field_189107_dL);
    }

    static {
        for (ItemInstrument handHeld : ModInstruments.INSTRUMENTS) {
            Instrument instrument = handHeld.getInstrument();
            if (SOUNDS.containsKey(instrument.sounds.timbre)) continue;
            SOUNDS.put(instrument.sounds.timbre, ModSoundEvents.registerSound(instrument.sounds.timbre));
        }
    }

    @Mod.EventBusSubscriber(modid="bard_mania")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
            SOUNDS.keySet().stream().filter(soundName -> soundName.contains("bard_mania:")).forEach(soundName -> event.getRegistry().register((IForgeRegistryEntry)SOUNDS.get(soundName)));
        }
    }
}

