/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.server.item;

import java.util.List;
import javax.annotation.Nullable;
import net.aeronica.mods.bard_mania.BardMania;
import net.aeronica.mods.bard_mania.client.MidiHelper;
import net.aeronica.mods.bard_mania.server.IActiveNoteReceiver;
import net.aeronica.mods.bard_mania.server.ModConfig;
import net.aeronica.mods.bard_mania.server.caps.BardActionHelper;
import net.aeronica.mods.bard_mania.server.network.PacketDispatcher;
import net.aeronica.mods.bard_mania.server.network.client.PlaySoundMessage;
import net.aeronica.mods.bard_mania.server.object.Instrument;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemInstrument
extends Item
implements IActiveNoteReceiver {
    private final Instrument instrument;

    public ItemInstrument(Instrument instrument) {
        this.instrument = instrument;
        this.setRegistryName(instrument.id.toLowerCase());
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77637_a(BardMania.MOD_TAB);
        this.func_77625_d(1);
        this.func_77627_a(false);
        this.func_77656_e(0);
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        if (worldIn.field_72995_K && playerIn.func_184600_cs().equals((Object)EnumHand.MAIN_HAND)) {
            if (playerIn.func_70093_af()) {
                BardMania.proxy.notifyRemoved(heldItem);
                ModConfig.toggleInputMode();
                BardMania.proxy.postInputModeToast(heldItem);
            } else {
                BardMania.proxy.setNoteReceiver(this.instrument.sounds.timbre);
            }
        }
        if (!worldIn.field_72995_K && playerIn.func_184600_cs().equals((Object)EnumHand.MAIN_HAND)) {
            boolean isEquipped = BardActionHelper.isInstrumentEquipped(playerIn);
            boolean isSneaking = playerIn.func_70093_af();
            if (isSneaking && isEquipped) {
                BardActionHelper.setInstrumentRemoved(playerIn);
            } else if (isEquipped) {
                BardActionHelper.setInstrumentRemoved(playerIn);
            } else if (!isSneaking) {
                BardActionHelper.setInstrumentEquipped(playerIn);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K && isSelected && stack.func_82838_A() != itemSlot && entityIn instanceof EntityPlayer) {
            stack.func_82841_c(itemSlot);
        } else if (!worldIn.field_72995_K && !isSelected && stack.func_82838_A() > -1) {
            stack.func_82841_c(-1);
            if (BardActionHelper.isInstrumentEquipped((EntityPlayer)entityIn)) {
                BardActionHelper.setInstrumentRemovedByForce((EntityPlayer)entityIn);
            }
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (!stack.func_190926_b()) {
            stack.func_82841_c(-1);
        }
        return null;
    }

    @Override
    public void noteReceiver(World worldIn, BlockPos posIn, int entityID, byte noteIn, byte volumeIn, long timeStamp) {
        EntityPlayer player;
        if (!worldIn.field_72995_K && (player = (EntityPlayer)worldIn.func_73045_a(entityID)) != null) {
            PacketDispatcher.sendToAllAround(new PlaySoundMessage(entityID, this.instrument.sounds.timbre, noteIn, volumeIn, timeStamp), player, 64.0);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (ModConfig.client.input_mode == ModConfig.Client.INPUT_MODE.MIDI) {
            tooltip.add(String.format("%s%s", TextFormatting.GRAY, I18n.func_135052_a((String)"tooltip.bard_mania.opened_midi_devices", (Object[])new Object[0])));
            MidiHelper.getOpenDeviceNames().stream().map(s -> String.format("%s %s", TextFormatting.GOLD, s)).forEach(tooltip::add);
            tooltip.add(String.format("%s%s", TextFormatting.GRAY, I18n.func_135052_a((String)"tooltip.bard_mania.right_click_to_activate_midi_input", (Object[])new Object[0])));
        } else {
            tooltip.add(String.format("%s%s", TextFormatting.GRAY, I18n.func_135052_a((String)"tooltip.bard_mania.right_click_to_activate_pc_keyboard", (Object[])new Object[0])));
        }
        tooltip.add(String.format("%s%s %s%s", TextFormatting.GRAY, I18n.func_135052_a((String)"tooltip.bard_mania.input_mode", (Object[])new Object[0]), TextFormatting.BLUE, I18n.func_135052_a((String)ModConfig.client.input_mode.toString(), (Object[])new Object[0])));
        tooltip.add(String.format("%s%s", TextFormatting.GRAY, I18n.func_135052_a((String)"tooltip.bard_mania.sneak_right_click_to_toggle_mode", (Object[])new Object[0])));
    }
}

