/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.server.network.bi;

import java.io.IOException;
import net.aeronica.mods.bard_mania.BardMania;
import net.aeronica.mods.bard_mania.client.MidiHelper;
import net.aeronica.mods.bard_mania.client.actions.base.ActionManager;
import net.aeronica.mods.bard_mania.client.audio.SoundHelper;
import net.aeronica.mods.bard_mania.server.ModLogger;
import net.aeronica.mods.bard_mania.server.caps.BardActionHelper;
import net.aeronica.mods.bard_mania.server.network.AbstractMessage;
import net.aeronica.mods.bard_mania.server.network.PacketDispatcher;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;

public class PoseActionMessage
extends AbstractMessage<PoseActionMessage> {
    public static final int APPLY = 0;
    public static final int EQUIP = 1;
    public static final int REMOVE = 2;
    private int posingPlayerId;
    private int actionId;
    private boolean forced = false;

    public PoseActionMessage() {
    }

    public PoseActionMessage(EntityPlayer posingPlayer, int actionIn, boolean byForce) {
        this.posingPlayerId = posingPlayer.func_145782_y();
        this.actionId = actionIn;
        this.forced = byForce;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.posingPlayerId = buffer.readInt();
        this.actionId = buffer.readInt();
        this.forced = buffer.readBoolean();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.posingPlayerId);
        buffer.writeInt(this.actionId);
        buffer.writeBoolean(this.forced);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (side.equals((Object)Side.CLIENT)) {
            this.processClient(player);
        } else {
            this.processServer(player);
        }
    }

    private void processClient(EntityPlayer player) {
        EntityPlayer posingPlayer = (EntityPlayer)BardMania.proxy.getClientWorld().func_73045_a(this.posingPlayerId);
        if (posingPlayer != null) {
            if (this.actionId == 0) {
                BardActionHelper.setInstrumentEquipped(posingPlayer);
                ActionManager.getModelDummy(posingPlayer).reset();
                ActionManager.applyPose(posingPlayer);
            } else if (this.actionId == 1) {
                BardActionHelper.setInstrumentEquipped(posingPlayer);
                ActionManager.getModelDummy(posingPlayer).reset();
                ActionManager.equipAction(posingPlayer);
            } else if (this.actionId == 2) {
                ActionManager.removeAction(posingPlayer);
                BardActionHelper.setInstrumentRemoved(posingPlayer);
                SoundHelper.stopNotes((EntityLivingBase)posingPlayer);
                if (player.func_145782_y() == this.posingPlayerId) {
                    if (this.forced) {
                        ActionManager.getModelDummy(posingPlayer).reset();
                        MidiHelper.INSTANCE.notifyRemoved("Force Removed by Server Request");
                    } else {
                        MidiHelper.INSTANCE.notifyRemoved("Removed by Server Request");
                    }
                }
            } else {
                ModLogger.debug("Pose Action %d does not exist", this.actionId);
            }
        } else {
            MidiHelper.INSTANCE.notifyRemoved("PoseActionMessage: Invalid posingPlayerId ***Dead***");
        }
    }

    private void processServer(EntityPlayer player) {
        EntityPlayer posingPlayer = (EntityPlayer)BardMania.proxy.getWorldByDimensionId(player.field_71093_bK).func_73045_a(this.posingPlayerId);
        if (posingPlayer != null) {
            PacketDispatcher.sendToDimension(new PoseActionMessage(posingPlayer, this.actionId, this.forced), posingPlayer.field_71093_bK);
        }
    }
}

