/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.blocks.BlockImpl;
import de.ellpeck.naturesaura.items.ItemSlabNA;
import de.ellpeck.naturesaura.reg.ICustomItemBlockProvider;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import org.apache.commons.lang3.mutable.MutableObject;

public abstract class BlockSlabsNA
extends BlockImpl
implements ICustomItemBlockProvider {
    protected static final PropertyEnum<BlockSlab.EnumBlockHalf> HALF = PropertyEnum.func_177709_a((String)"half", BlockSlab.EnumBlockHalf.class);
    protected static final AxisAlignedBB AABB_BOTTOM_HALF = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_TOP_HALF = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    private final Supplier<BlockSlabsNA> singleSlab;
    private final Supplier<BlockSlabsNA> doubleSlab;

    public BlockSlabsNA(String baseName, Material materialIn, Supplier<BlockSlabsNA> singleSlab, Supplier<BlockSlabsNA> doubleSlab) {
        super(baseName, materialIn);
        this.singleSlab = singleSlab;
        this.doubleSlab = doubleSlab;
    }

    @Override
    public CreativeTabs getTabToAdd() {
        return this.isDouble() ? null : super.getTabToAdd();
    }

    protected boolean func_149700_E() {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.isDouble()) {
            return field_185505_j;
        }
        return state.func_177229_b(HALF) == BlockSlab.EnumBlockHalf.TOP ? AABB_TOP_HALF : AABB_BOTTOM_HALF;
    }

    public boolean func_185481_k(IBlockState state) {
        return this.isDouble() || state.func_177229_b(HALF) == BlockSlab.EnumBlockHalf.TOP;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (this.isDouble()) {
            return BlockFaceShape.SOLID;
        }
        if (face == EnumFacing.UP && state.func_177229_b(HALF) == BlockSlab.EnumBlockHalf.TOP) {
            return BlockFaceShape.SOLID;
        }
        return face == EnumFacing.DOWN && state.func_177229_b(HALF) == BlockSlab.EnumBlockHalf.BOTTOM ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.isDouble();
    }

    public boolean func_149686_d(IBlockState state) {
        return this.isDouble();
    }

    public boolean func_149730_j(IBlockState state) {
        return this.isDouble();
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isDouble();
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (ForgeModContainer.disableStairSlabCulling) {
            return super.doesSideBlockRendering(state, world, pos, face);
        }
        if (state.func_185914_p()) {
            return true;
        }
        BlockSlab.EnumBlockHalf side = (BlockSlab.EnumBlockHalf)state.func_177229_b(HALF);
        return side == BlockSlab.EnumBlockHalf.TOP && face == EnumFacing.UP || side == BlockSlab.EnumBlockHalf.BOTTOM && face == EnumFacing.DOWN;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.isDouble()) {
            return this.func_176223_P();
        }
        IBlockState state = this.func_176203_a(meta);
        return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? state.func_177226_a(HALF, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM) : state.func_177226_a(HALF, (Comparable)BlockSlab.EnumBlockHalf.TOP);
    }

    public int func_149745_a(Random random) {
        return this.isDouble() ? 2 : 1;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.singleSlab.get());
    }

    @Override
    public ItemBlock getItemBlock() {
        return new ItemSlabNA(this, this.singleSlab, this.doubleSlab);
    }

    protected BlockStateContainer func_180661_e() {
        return this.isDouble() ? new BlockStateContainer((Block)this, new IProperty[0]) : new BlockStateContainer((Block)this, new IProperty[]{HALF});
    }

    public int func_176201_c(IBlockState state) {
        return this.isDouble() ? 0 : (state.func_177229_b(HALF) == BlockSlab.EnumBlockHalf.TOP ? 1 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.isDouble() ? this.func_176223_P() : this.func_176223_P().func_177226_a(HALF, (Comparable)(meta == 1 ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM));
    }

    public abstract boolean isDouble();

    public static BlockSlabsNA makeSlab(String baseName, Material material, SoundType soundType, float hardness) {
        MutableObject singl = new MutableObject();
        MutableObject doubl = new MutableObject();
        singl.setValue((Object)new BlockSlabsNA(baseName, material, () -> ((MutableObject)singl).getValue(), () -> ((MutableObject)doubl).getValue()){

            @Override
            public boolean isDouble() {
                return false;
            }
        });
        ((BlockSlabsNA)singl.getValue()).func_149672_a(soundType).func_149711_c(hardness);
        doubl.setValue((Object)new BlockSlabsNA(baseName + "_double", material, () -> ((MutableObject)singl).getValue(), () -> ((MutableObject)doubl).getValue()){

            @Override
            public boolean isDouble() {
                return true;
            }
        });
        ((BlockSlabsNA)doubl.getValue()).func_149672_a(soundType).func_149711_c(hardness);
        return (BlockSlabsNA)singl.getValue();
    }
}

