/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticleStream;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableInt;

public class TileEntityFlowerGenerator
extends TileEntityImpl
implements ITickable {
    private final Map<IBlockState, MutableInt> consumedRecently = new HashMap<IBlockState, MutableInt>();

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 10L == 0L) {
            ArrayList<BlockPos> possible = new ArrayList<BlockPos>();
            int range = 3;
            for (int x = -range; x <= range; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos offset = this.field_174879_c.func_177982_a(x, y, z);
                        IBlockState state = this.field_145850_b.func_180495_p(offset);
                        if (!NaturesAuraAPI.FLOWERS.contains(state)) continue;
                        possible.add(offset);
                    }
                }
            }
            if (possible.isEmpty()) {
                return;
            }
            int addAmount = 25000;
            BlockPos pos = (BlockPos)possible.get(this.field_145850_b.field_73012_v.nextInt(possible.size()));
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            MutableInt curr = this.consumedRecently.computeIfAbsent(state, s -> new MutableInt());
            int toAdd = Math.max(0, addAmount - curr.getValue() * 100);
            if (toAdd > 0) {
                if (IAuraType.forWorld(this.field_145850_b).isSimilar(NaturesAuraAPI.TYPE_OVERWORLD) && this.canGenerateRightNow(30, toAdd)) {
                    BlockPos spot;
                    for (int remain = toAdd; remain > 0; remain -= IAuraChunk.getAuraChunk(this.field_145850_b, spot).storeAura(spot, remain)) {
                        spot = IAuraChunk.getLowestSpot(this.field_145850_b, this.field_174879_c, 30, this.field_174879_c);
                    }
                } else {
                    toAdd = 0;
                }
            }
            for (Map.Entry<IBlockState, MutableInt> entry : this.consumedRecently.entrySet()) {
                MutableInt val;
                if (entry.getKey() == state || (val = entry.getValue()).getValue() <= 0) continue;
                val.subtract(1);
            }
            curr.add(5);
            this.field_145850_b.func_175698_g(pos);
            int color = Helper.blendColors(6081584, 15023126, (float)toAdd / (float)addAmount);
            if (toAdd > 0) {
                for (int i = this.field_145850_b.field_73012_v.nextInt(5) + 5; i >= 0; --i) {
                    PacketHandler.sendToAllAround(this.field_145850_b, this.field_174879_c, 32, new PacketParticleStream((float)pos.func_177958_n() + 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f, (float)pos.func_177956_o() + 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f, (float)pos.func_177952_p() + 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f, (float)this.field_174879_c.func_177958_n() + 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f, (float)this.field_174879_c.func_177956_o() + 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f, (float)this.field_174879_c.func_177952_p() + 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.02f + 0.1f, color, 1.0f));
                }
                PacketHandler.sendToAllAround(this.field_145850_b, this.field_174879_c, 32, new PacketParticles(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 8, new int[0]));
            }
            PacketHandler.sendToAllAround(this.field_145850_b, this.field_174879_c, 32, new PacketParticles(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 7, color));
        }
    }

    @Override
    public boolean wantsLimitRemover() {
        return true;
    }

    @Override
    public void writeNBT(NBTTagCompound compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != TileEntityImpl.SaveType.SYNC && !this.consumedRecently.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<IBlockState, MutableInt> entry : this.consumedRecently.entrySet()) {
                IBlockState state = entry.getKey();
                Block block = state.func_177230_c();
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("block", block.getRegistryName().toString());
                tag.func_74768_a("meta", block.func_176201_c(state));
                tag.func_74768_a("amount", entry.getValue().intValue());
                list.func_74742_a((NBTBase)tag);
            }
            compound.func_74782_a("consumed_recently", (NBTBase)list);
        }
    }

    @Override
    public void readNBT(NBTTagCompound compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != TileEntityImpl.SaveType.SYNC) {
            this.consumedRecently.clear();
            NBTTagList list = compound.func_150295_c("consumed_recently", 10);
            for (NBTBase base : list) {
                NBTTagCompound tag = (NBTTagCompound)base;
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tag.func_74779_i("block")));
                if (block == null) continue;
                IBlockState state = block.func_176203_a(tag.func_74762_e("meta"));
                this.consumedRecently.put(state, new MutableInt(tag.func_74762_e("amount")));
            }
        }
    }
}

