/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.api.recipes.WeightedOre;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.oredict.OreDictionary;

public class OreSpawnEffect
implements IDrainSpotEffect {
    public static final Set<IBlockState> SPAWN_EXCEPTIONS = new HashSet<IBlockState>();
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "ore_spawn");
    private int amount;
    private int dist;

    private boolean calcValues(World world, BlockPos pos, Integer spot) {
        if (spot <= 0) {
            return false;
        }
        int aura = IAuraChunk.getAuraInArea(world, pos, 30);
        if (aura <= 2000000) {
            return false;
        }
        this.amount = Math.min(20, MathHelper.func_76123_f((float)((float)Math.abs(aura) / 300000.0f / (float)IAuraChunk.getSpotAmountInArea(world, pos, 30))));
        if (this.amount <= 0) {
            return false;
        }
        this.dist = MathHelper.func_76125_a((int)(Math.abs(aura) / 150000), (int)5, (int)20);
        return true;
    }

    @Override
    public int isActiveHere(EntityPlayer player, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.field_70170_p, pos, spot)) {
            return -1;
        }
        if (player.func_174818_b(pos) > (double)(this.dist * this.dist)) {
            return -1;
        }
        if (!NaturesAuraAPI.instance().isEffectPowderActive(player.field_70170_p, player.func_180425_c(), NAME)) {
            return 0;
        }
        return 1;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack(Blocks.field_150482_ag);
    }

    @Override
    public void update(World world, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        List<WeightedOre> ores;
        Block requiredBlock;
        if (world.func_82737_E() % 40L != 0L) {
            return;
        }
        if (!this.calcValues(world, pos, spot)) {
            return;
        }
        IAuraType type = auraChunk.getType();
        if (type.isSimilar(NaturesAuraAPI.TYPE_OVERWORLD)) {
            requiredBlock = Blocks.field_150348_b;
            ores = NaturesAuraAPI.OVERWORLD_ORES;
        } else {
            requiredBlock = Blocks.field_150424_aL;
            ores = NaturesAuraAPI.NETHER_ORES;
        }
        int totalWeight = WeightedRandom.func_76272_a(ores);
        List<Tuple<Vec3d, Integer>> powders = NaturesAuraAPI.instance().getActiveEffectPowders(world, new AxisAlignedBB(pos).func_186662_g((double)this.dist), NAME);
        if (powders.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.amount; ++i) {
            IBlockState stateToPlace;
            WeightedOre ore;
            IBlockState state;
            Block block;
            int z;
            int y;
            Tuple<Vec3d, Integer> powder = powders.get(i % powders.size());
            Vec3d powderPos = (Vec3d)powder.func_76341_a();
            int range = (Integer)powder.func_76340_b();
            int x = MathHelper.func_76128_c((double)(powderPos.field_72450_a + world.field_73012_v.nextGaussian() * (double)range));
            BlockPos orePos = new BlockPos(x, y = MathHelper.func_76128_c((double)(powderPos.field_72448_b + world.field_73012_v.nextGaussian() * (double)range)), z = MathHelper.func_76128_c((double)(powderPos.field_72449_c + world.field_73012_v.nextGaussian() * (double)range)));
            if (!(orePos.func_177954_c(powderPos.field_72450_a, powderPos.field_72448_b, powderPos.field_72449_c) <= (double)(range * range)) || !(orePos.func_177951_i((Vec3i)pos) <= (double)(this.dist * this.dist)) || !world.func_175667_e(orePos) || (block = (state = world.func_180495_p(orePos)).func_177230_c()) != requiredBlock) continue;
            block1: while (true) {
                ore = (WeightedOre)WeightedRandom.func_76273_a((Random)world.field_73012_v, ores, (int)totalWeight);
                NonNullList stacks = OreDictionary.getOres((String)ore.name, (boolean)false);
                Iterator iterator = stacks.iterator();
                while (true) {
                    Block toPlace;
                    if (!iterator.hasNext()) continue block1;
                    ItemStack stack = (ItemStack)iterator.next();
                    if (stack.func_190926_b() || (toPlace = Block.func_149634_a((Item)stack.func_77973_b())) == Blocks.field_150350_a) continue;
                    FakePlayer player = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
                    stateToPlace = toPlace.getStateForPlacement(world, pos, EnumFacing.UP, 0.0f, 0.0f, 0.0f, stack.func_77960_j(), (EntityLivingBase)player, EnumHand.MAIN_HAND);
                    if (!SPAWN_EXCEPTIONS.contains(stateToPlace)) break block1;
                }
                break;
            }
            world.func_175656_a(orePos, stateToPlace);
            world.func_175718_b(2001, orePos, Block.func_176210_f((IBlockState)stateToPlace));
            int toDrain = (20000 - ore.field_76292_a * 2) * 2;
            BlockPos highestSpot = IAuraChunk.getHighestSpot(world, orePos, 30, pos);
            IAuraChunk.getAuraChunk(world, highestSpot).drainAura(highestSpot, toDrain);
        }
    }

    @Override
    public boolean appliesHere(Chunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return ModConfig.enabledFeatures.oreEffect && (type.isSimilar(NaturesAuraAPI.TYPE_OVERWORLD) || type.isSimilar(NaturesAuraAPI.TYPE_NETHER));
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

