/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.api.cap.BaublesCapabilities;
import de.ellpeck.naturesaura.items.ModItems;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BaublesCompat {
    @SubscribeEvent
    public void onCapabilitiesAttach(AttachCapabilitiesEvent<ItemStack> event) {
        Item item = ((ItemStack)event.getObject()).func_77973_b();
        if (item == ModItems.EYE || item == ModItems.EYE_IMPROVED) {
            this.addCap(event, stack -> BaubleType.CHARM);
        } else if (item == ModItems.AURA_CACHE) {
            this.addCap(event, new UpdatingBauble(BaubleType.BELT, true));
        } else if (item == ModItems.AURA_TROVE) {
            this.addCap(event, new UpdatingBauble(BaubleType.BELT, true));
        } else if (item == ModItems.SHOCKWAVE_CREATOR) {
            this.addCap(event, new UpdatingBauble(BaubleType.AMULET, false));
        }
    }

    private void addCap(AttachCapabilitiesEvent<ItemStack> event, final IBauble type) {
        event.addCapability(new ResourceLocation("naturesaura", "bauble"), new ICapabilityProvider(){

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE;
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                return (T)(capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE ? type : null);
            }
        });
    }

    private static class UpdatingBauble
    implements IBauble {
        private final BaubleType type;
        private final boolean sync;

        public UpdatingBauble(BaubleType type, boolean sync) {
            this.type = type;
            this.sync = sync;
        }

        public BaubleType getBaubleType(ItemStack itemstack) {
            return this.type;
        }

        public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
            return this.sync;
        }

        public void onWornTick(ItemStack stack, EntityLivingBase player) {
            stack.func_77973_b().func_77663_a(stack, player.field_70170_p, (Entity)player, -1, false);
        }
    }
}

