/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAuraBottle
extends ItemImpl
implements IColorProvidingItem {
    public ItemAuraBottle() {
        super("aura_bottle");
        MinecraftForge.EVENT_BUS.register((Object)this);
        BlockDispenser.field_149943_a.func_82595_a((Object)ModItems.BOTTLE_TWO, (Object)new BehaviorDefaultDispenseItem(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                World world = source.func_82618_k();
                IBlockState state = source.func_189992_e();
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockDispenser.field_176441_a);
                BlockPos offset = source.func_180699_d().func_177972_a(facing);
                IBlockState offsetState = world.func_180495_p(offset);
                ItemStack dispense = stack.func_77979_a(1);
                if (offsetState.func_177230_c().isAir(offsetState, (IBlockAccess)world, offset) && IAuraChunk.getAuraInArea(world, offset, 30) >= 100000) {
                    dispense = ItemAuraBottle.setType(new ItemStack((Item)ItemAuraBottle.this), IAuraType.forWorld(world));
                    BlockPos spot = IAuraChunk.getHighestSpot(world, offset, 30, offset);
                    IAuraChunk.getAuraChunk(world, spot).drainAura(spot, 20000);
                }
                1.func_82486_a((World)world, (ItemStack)dispense, (int)6, (EnumFacing)facing, (IPosition)BlockDispenser.func_149939_a((IBlockSource)source));
                return stack;
            }
        });
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack held = event.getItemStack();
        if (held.func_190926_b() || held.func_77973_b() != ModItems.BOTTLE_TWO) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        RayTraceResult ray = this.func_77621_a(player.field_70170_p, player, true);
        if (ray != null && ray.field_72313_a == RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos pos = player.func_180425_c();
        if (IAuraChunk.getAuraInArea(player.field_70170_p, pos, 30) < 100000) {
            return;
        }
        if (!player.field_70170_p.field_72995_K) {
            held.func_190918_g(1);
            player.field_71071_by.func_70441_a(ItemAuraBottle.setType(new ItemStack((Item)this), IAuraType.forWorld(player.field_70170_p)));
            BlockPos spot = IAuraChunk.getHighestSpot(player.field_70170_p, pos, 30, pos);
            IAuraChunk.getAuraChunk(player.field_70170_p, spot).drainAura(spot, 20000);
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187618_I, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        player.func_184609_a(event.getHand());
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (IAuraType type : NaturesAuraAPI.AURA_TYPES.values()) {
                ItemStack stack = new ItemStack((Item)this);
                ItemAuraBottle.setType(stack, type);
                items.add((Object)stack);
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)(this.func_77657_g(stack) + "." + ItemAuraBottle.getType(stack).getName() + ".name")).trim();
    }

    public static IAuraType getType(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return NaturesAuraAPI.TYPE_OTHER;
        }
        String type = stack.func_77978_p().func_74779_i("stored_type");
        if (type.isEmpty()) {
            return NaturesAuraAPI.TYPE_OTHER;
        }
        return NaturesAuraAPI.AURA_TYPES.get(new ResourceLocation(type));
    }

    public static ItemStack setType(ItemStack stack, IAuraType type) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a("stored_type", type.getName().toString());
        return stack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return (stack, tintIndex) -> tintIndex > 0 ? ItemAuraBottle.getType(stack).getColor() : 0xFFFFFF;
    }
}

