/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.render.ITrinketItem;
import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.items.tools.ItemArmorNA;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemShockwaveCreator
extends ItemImpl
implements ITrinketItem {
    private static final ResourceLocation RES_WORN = new ResourceLocation("naturesaura", "textures/items/shockwave_creator_player.png");

    public ItemShockwaveCreator() {
        super("shockwave_creator");
        this.func_77625_d(1);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.field_72995_K || !(entityIn instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase living = (EntityLivingBase)entityIn;
        if (!living.field_70122_E) {
            NBTTagCompound compound;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if ((compound = stack.func_77978_p()).func_74767_n("air")) {
                return;
            }
            compound.func_74757_a("air", true);
            compound.func_74780_a("x", living.field_70165_t);
            compound.func_74780_a("y", living.field_70163_u);
            compound.func_74780_a("z", living.field_70161_v);
        } else {
            BlockPos pos;
            BlockPos down;
            IBlockState downState;
            if (!stack.func_77942_o()) {
                return;
            }
            NBTTagCompound compound = stack.func_77978_p();
            if (!compound.func_74767_n("air")) {
                return;
            }
            compound.func_74757_a("air", false);
            if (!living.func_70093_af()) {
                return;
            }
            if (living.func_70092_e(compound.func_74769_h("x"), compound.func_74769_h("y"), compound.func_74769_h("z")) > 0.75) {
                return;
            }
            if (living instanceof EntityPlayer && !NaturesAuraAPI.instance().extractAuraFromPlayer((EntityPlayer)living, 1000, false)) {
                return;
            }
            DamageSource source = living instanceof EntityPlayer ? DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)living)) : DamageSource.field_76376_m;
            boolean infusedSet = ItemArmorNA.isFullSetEquipped(living, 0);
            int range = 5;
            List mobs = worldIn.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(living.field_70165_t - (double)range, living.field_70163_u - 0.5, living.field_70161_v - (double)range, living.field_70165_t + (double)range, living.field_70163_u + 0.5, living.field_70161_v + (double)range));
            for (EntityLivingBase mob : mobs) {
                if (mob.field_70128_L || mob == living || living.func_70068_e((Entity)mob) > (double)(range * range)) continue;
                if (living instanceof EntityPlayer && !NaturesAuraAPI.instance().extractAuraFromPlayer((EntityPlayer)living, 500, false)) break;
                mob.func_70097_a(source, 4.0f);
                if (!infusedSet) continue;
                mob.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 120));
            }
            if ((downState = worldIn.func_180495_p(down = (pos = living.func_180425_c()).func_177977_b())).func_185904_a() != Material.field_151579_a) {
                SoundType type = downState.func_177230_c().getSoundType(downState, worldIn, down, null);
                worldIn.func_184133_a(null, pos, type.func_185845_c(), SoundCategory.BLOCKS, type.func_185843_a() * 0.5f, type.func_185847_b() * 0.8f);
            }
            if (worldIn instanceof WorldServer) {
                ((WorldServer)worldIn).func_175739_a(EnumParticleTypes.BLOCK_DUST, living.field_70165_t, living.field_70163_u + (double)0.01f, living.field_70161_v, 15, 0.0, 0.0, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)downState)});
            }
            PacketHandler.sendToAllAround(worldIn, pos, 32, new PacketParticles((float)living.field_70165_t, (float)living.field_70163_u, (float)living.field_70161_v, 11, new int[0]));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(ItemStack stack, EntityPlayer player, ITrinketItem.RenderType type, boolean isHolding) {
        if (type == ITrinketItem.RenderType.BODY && !isHolding) {
            boolean armor = !((ItemStack)player.field_71071_by.field_70460_b.get(EntityEquipmentSlot.CHEST.func_188454_b())).func_190926_b();
            GlStateManager.func_179109_b((float)-0.1675f, (float)-0.05f, (float)(armor ? -0.195f : -0.1475f));
            GlStateManager.func_179152_a((float)0.021f, (float)0.021f, (float)0.021f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            GlStateManager.func_179123_a();
            RenderHelper.func_74519_b();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(RES_WORN);
            Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
            RenderHelper.func_74518_a();
            GlStateManager.func_179099_b();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }
}

