/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.attributes.common.skills.defense;

import codersafterdark.attributes.utils.AttributesConfigHandler;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.PlayerSkillInfo;
import codersafterdark.reskillable.api.unlockable.Trait;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class TraitResistance
extends Trait {
    public int level = 1;

    public TraitResistance() {
        super(new ResourceLocation("attributes", "resistancebuff"), 0, 3, new ResourceLocation("reskillable", "defense"), 0, new String[]{""});
    }

    public void onHurt(LivingHurtEvent event) {
        if (event.isCanceled() || !(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        float baseDamage = event.getAmount();
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        PlayerData data = PlayerDataHandler.get((EntityPlayer)player);
        PlayerSkillInfo info = data.getSkillInfo(this.getParentSkill());
        event.setAmount(baseDamage -= AttributesConfigHandler.AttributesConfigs.Defense.resBuff * (float)info.getLevel());
    }

    public String getDescription() {
        StringBuilder builder = new StringBuilder(new TextComponentTranslation("reskillable.unlock." + this.getKey() + ".desc", new Object[0]).func_150261_e());
        builder.append(" Damage Reduction Gained: ").append(AttributesConfigHandler.AttributesConfigs.Defense.resBuff * (float)this.level);
        return builder.toString();
    }
}

