/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.core;

import biomesoplenty.api.item.BOPItems;
import biomesoplenty.api.particle.BOPParticleTypes;
import biomesoplenty.client.particle.EntityCurseFX;
import biomesoplenty.client.particle.EntityTrailFX;
import biomesoplenty.common.block.IBOPBlock;
import biomesoplenty.common.config.MiscConfigurationHandler;
import biomesoplenty.common.entities.EntityWasp;
import biomesoplenty.common.entities.RenderWasp;
import biomesoplenty.common.entities.item.EntityBOPBoat;
import biomesoplenty.common.entities.item.RenderBOPBoat;
import biomesoplenty.common.entities.projectiles.EntityMudball;
import biomesoplenty.common.entities.projectiles.RenderMudball;
import biomesoplenty.common.item.IColoredItem;
import biomesoplenty.common.util.inventory.CreativeTabBOP;
import biomesoplenty.core.CommonProxy;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientProxy
extends CommonProxy {
    public static ResourceLocation[] bopTitlePanoramaPaths = new ResourceLocation[]{new ResourceLocation("biomesoplenty:textures/gui/title/background/panorama_0.png"), new ResourceLocation("biomesoplenty:textures/gui/title/background/panorama_1.png"), new ResourceLocation("biomesoplenty:textures/gui/title/background/panorama_2.png"), new ResourceLocation("biomesoplenty:textures/gui/title/background/panorama_3.png"), new ResourceLocation("biomesoplenty:textures/gui/title/background/panorama_4.png"), new ResourceLocation("biomesoplenty:textures/gui/title/background/panorama_5.png")};
    public static ResourceLocation particleTexturesLocation = new ResourceLocation("biomesoplenty:textures/particles/particles.png");
    private static List<Block> blocksToColour = Lists.newArrayList();
    private static List<Item> itemsToColor = Lists.newArrayList();

    @Override
    public void registerRenderers() {
        if (MiscConfigurationHandler.overrideTitlePanorama) {
            GuiMainMenu.field_73978_o = bopTitlePanoramaPaths;
        }
        ClientProxy.registerEntityRenderer(EntityWasp.class, RenderWasp.class);
        ClientProxy.registerEntityRenderer(EntityMudball.class, RenderMudball.class);
        ClientProxy.registerEntityRenderer(EntityBOPBoat.class, RenderBOPBoat.class);
    }

    @Override
    public void registerColouring() {
        for (Block block : blocksToColour) {
            IBOPBlock bopBlock = (IBOPBlock)block;
            if (bopBlock.getBlockColor() != null) {
                Minecraft.func_71410_x().func_184125_al().func_186722_a(bopBlock.getBlockColor(), new Block[]{block});
            }
            if (bopBlock.getItemColor() == null) continue;
            Minecraft.func_71410_x().getItemColors().func_186731_a(bopBlock.getItemColor(), new Block[]{block});
        }
        for (Item item : itemsToColor) {
            IColoredItem coloredItem = (IColoredItem)item;
            Minecraft.func_71410_x().getItemColors().func_186730_a(coloredItem.getItemColor(), new Item[]{item});
        }
    }

    @Override
    public void registerItemVariantModel(Item item, String name, int metadata) {
        Preconditions.checkNotNull((Object)item, (Object)("Cannot register models for null item " + name));
        Preconditions.checkArgument((item != Items.field_190931_a ? 1 : 0) != 0, (Object)("Cannot register models for air (" + name + ")"));
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("biomesoplenty:" + name)});
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation("biomesoplenty:" + name, "inventory"));
    }

    @Override
    public void registerBlockSided(Block block) {
        if (block instanceof IBOPBlock) {
            IBOPBlock bopBlock = (IBOPBlock)block;
            IProperty[] nonRenderingProperties = bopBlock.getNonRenderingProperties();
            if (nonRenderingProperties != null) {
                StateMap custom_mapper = new StateMap.Builder().func_178442_a(nonRenderingProperties).func_178441_a();
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)custom_mapper);
            }
            if (bopBlock.getBlockColor() != null || bopBlock.getItemColor() != null) {
                blocksToColour.add(block);
            }
        }
    }

    @Override
    public void registerItemSided(Item item) {
        if (item.func_77614_k()) {
            NonNullList subItems = NonNullList.func_191196_a();
            item.func_150895_a(CreativeTabBOP.instance, subItems);
            for (ItemStack subItem : subItems) {
                String subItemName = item.func_77667_c(subItem);
                subItemName = subItemName.substring(subItemName.indexOf(".") + 1);
                ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("biomesoplenty", subItemName)});
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)subItem.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation("biomesoplenty:" + subItemName, "inventory"));
            }
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("biomesoplenty:" + item.delegate.name().func_110623_a(), "inventory"));
        }
        if (item instanceof IColoredItem && ((IColoredItem)item).getItemColor() != null) {
            itemsToColor.add(item);
        }
    }

    @Override
    public void registerFluidBlockRendering(Block block, String name) {
        final ModelResourceLocation fluidLocation = new ModelResourceLocation("biomesoplenty".toLowerCase() + ":fluids", name);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return fluidLocation;
            }
        });
    }

    @Override
    public void spawnParticle(BOPParticleTypes type, double x, double y, double z, Object ... info) {
        Minecraft minecraft = Minecraft.func_71410_x();
        WorldClient world = minecraft.field_71441_e;
        if (world == null) {
            return;
        }
        Particle entityFx = null;
        switch (type) {
            case MUD: {
                int itemId = Item.func_150891_b((Item)BOPItems.mudball);
                minecraft.field_71441_e.func_175688_a(EnumParticleTypes.ITEM_CRACK, x, y, z, MathHelper.func_82716_a((Random)world.field_73012_v, (double)-0.08, (double)0.08), MathHelper.func_82716_a((Random)world.field_73012_v, (double)-0.08, (double)0.08), MathHelper.func_82716_a((Random)world.field_73012_v, (double)-0.08, (double)0.08), new int[]{itemId});
                return;
            }
            case PLAYER_TRAIL: {
                if (info.length < 1) {
                    throw new RuntimeException("Missing argument for trail name!");
                }
                entityFx = new EntityTrailFX((World)world, x, y, z, (String)info[0]);
                break;
            }
            case CURSE: {
                entityFx = new EntityCurseFX((World)world, x, y, z, MathHelper.func_82716_a((Random)world.field_73012_v, (double)-0.03, (double)0.03), 0.05, MathHelper.func_82716_a((Random)world.field_73012_v, (double)-0.03, (double)0.03));
                break;
            }
        }
        if (entityFx != null) {
            minecraft.field_71452_i.func_78873_a(entityFx);
        }
    }

    private static <E extends Entity> void registerEntityRenderer(Class<E> entityClass, Class<? extends Render<E>> renderClass) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, new EntityRenderFactory(renderClass));
    }

    private static class EntityRenderFactory<E extends Entity>
    implements IRenderFactory<E> {
        private Class<? extends Render<E>> renderClass;

        private EntityRenderFactory(Class<? extends Render<E>> renderClass) {
            this.renderClass = renderClass;
        }

        public Render<E> createRenderFor(RenderManager manager) {
            Render<E> renderer = null;
            try {
                renderer = this.renderClass.getConstructor(RenderManager.class).newInstance(manager);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return renderer;
        }
    }
}

