/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.config;

import epicsquid.mysticalworld.world.WorldGeneratorTrees;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="mysticalworld")
@Mod.EventBusSubscriber(modid="mysticalworld")
public class ConfigManager {
    @Config.Comment(value={"Grant the Patchouli-based Guide Book when first joining the server"})
    public static boolean GiveBook = true;
    @Config.Comment(value={"Inject some items from Mystical World into dungeon & other loot chests"})
    public static boolean InjectLoot = true;
    @Config.Comment(value={"Enable squid drops"})
    public static boolean InjectSquid = true;
    @Config.Comment(value={"Minimum number of pulls for injected loot"})
    public static int InjectMinimum = 1;
    @Config.Comment(value={"Maximum nubmer of pulls for injected loot"})
    public static int InjectMaximum = 1;
    @Config.Comment(value={"Controls the spawning of mobs in Mystical World and dependent mods."})
    public static ConfigMysticalWorldMobs mobs = new ConfigMysticalWorldMobs();
    @Config.Comment(value={"Controls the spawn settings of Deer"})
    public static ConfigMysticalWorldDeer deer = new ConfigMysticalWorldDeer();
    @Config.Comment(value={"Controls the spawn settings of Foxes"})
    public static ConfigMysticalWorldFox fox = new ConfigMysticalWorldFox();
    @Config.Comment(value={"Controls the spawn settings of Beetle"})
    public static ConfigMysticalWorldBeetle beetle = new ConfigMysticalWorldBeetle();
    @Config.Comment(value={"Controls the spawn settings of Frog"})
    public static ConfigMysticalWorldFrog frog = new ConfigMysticalWorldFrog();
    @Config.Comment(value={"Controls the spawn settings of Sprout"})
    public static ConfigMysticalWorldSprout sprout = new ConfigMysticalWorldSprout();
    @Config.Comment(value={"Controls the spawn settings of Endermini"})
    public static ConfigMysticalWorldEndermini endermini = new ConfigMysticalWorldEndermini();
    @Config.Comment(value={"Controls the spawn settings of owls"})
    public static ConfigMysticalWorldOwl owl = new ConfigMysticalWorldOwl();
    @Config.Comment(value={"Controls the spawn settings of silkworms"})
    public static ConfigMysticalWorldSilkworm silkworm = new ConfigMysticalWorldSilkworm();
    @Config.Comment(value={"Controls the spawn settings of lava cats"})
    public static ConfigMysticalWorldLavaCat lavaCat = new ConfigMysticalWorldLavaCat();
    @Config.Comment(value={"Minimum distance between Barrow structures. Set to -1 to disable."})
    @Config.RangeInt(min=-1)
    public static int BarrowDistance = 400;
    @Config.Comment(value={"Mininmum distance between Hut structures. Set to -1 to disable."})
    @Config.RangeInt(min=-1)
    public static int HutDistance = 400;
    @Config.Comment(value={"Spawn options for burn trees"})
    @Config.Name(value="Burnt Trees")
    public static ConfigMysticalWorldBurntTrees burntTrees = new ConfigMysticalWorldBurntTrees();
    @Config.Comment(value={"Mystical world gold dusts"})
    public static ConfigMysticalWorldGold gold = new ConfigMysticalWorldGold();
    @Config.Comment(value={"Mystical world iron dusts"})
    public static ConfigMysticalWorldIron iron = new ConfigMysticalWorldIron();
    @Config.Comment(value={"Mystical world gems and their components"})
    public static ConfigMysticalWorldAmethyst amethyst = new ConfigMysticalWorldAmethyst();
    @Config.Comment(value={"Mystical world copper options"})
    public static ConfigMysticalWorldCopper copper = new ConfigMysticalWorldCopper();
    @Config.Comment(value={"Mystical world silver options"})
    public static ConfigMysticalWorldSilver silver = new ConfigMysticalWorldSilver();
    @Config.Comment(value={"Tool/Weapon Enablind"})
    public static ConfigMysticalWorldToolEnable toolEnable = new ConfigMysticalWorldToolEnable();
    @Config.Comment(value={"Ore Debugging Options"})
    public static ConfigMysticalWorldOreDebugging oreDebugging = new ConfigMysticalWorldOreDebugging();
    @Config.Comment(value={"Controls ore generation for Mystical World Ores."})
    public static ConfigMysticalWorldOreGen oreGen = new ConfigMysticalWorldOreGen();

    @SubscribeEvent
    public static void syncConfig(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("mysticalworld")) {
            net.minecraftforge.common.config.ConfigManager.sync((String)"mysticalworld", (Config.Type)Config.Type.INSTANCE);
            WorldGeneratorTrees.invalidTypes.clear();
        }
    }

    public static int safeInt(int incoming) {
        return Math.max(1, incoming);
    }

    public static class ConfigMysticalWorldOreGen {
        @Config.Comment(value={"List of dimensions to spawn ore in (default 0)"})
        public String[] dimensions = new String[]{"0"};
        @Config.Ignore
        private IntOpenHashSet spawnDimensions = null;
        @Config.Comment(value={"The amount of copper veins to generate per chunk. Set to 0 to disable."})
        public int copperPerChunk = 6;
        @Config.Comment(value={"The maximum size of a copper ore vein."})
        public int copperVeinSize = 12;
        @Config.Comment(value={"The highest a copper ore vein can generate."})
        @Config.RangeInt(min=0, max=255)
        public int copperMaxY = 64;
        @Config.Comment(value={"The lowest a copper of vein can generate."})
        @Config.RangeInt(min=0, max=255)
        public int copperMinY = 0;
        @Config.Comment(value={"The amount of amethyst veins to generate per chunk. Set to 0 to disable."})
        public int amethystPerChunk = 2;
        @Config.Comment(value={"The maximum size of an amethyst ore vein."})
        public int amethystVeinSize = 5;
        @Config.Comment(value={"The highest an amethyst ore vein can generate"})
        @Config.RangeInt(min=0, max=255)
        public int amethystMaxY = 32;
        @Config.Comment(value={"The lowest an amethsyt ore vein can generate"})
        @Config.RangeInt(min=0, max=255)
        public int amethystMinY = 5;
        @Config.Comment(value={"The amount of silver veins to generate per chunk. Set to 0 to disable."})
        public int silverPerChunk = 4;
        @Config.Comment(value={"The maximum size of a silver ore vein."})
        public int silverVeinSize = 8;
        @Config.Comment(value={"The highest a silver ore vein can generate."})
        @Config.RangeInt(min=0, max=255)
        public int silverMaxY = 28;
        @Config.Comment(value={"The lowest a silver of vein can generate."})
        @Config.RangeInt(min=0, max=255)
        public int silverMinY = 0;

        public IntOpenHashSet getSpawnDimensions() {
            if (this.spawnDimensions == null) {
                this.spawnDimensions = new IntOpenHashSet();
                for (String dim : this.dimensions) {
                    this.spawnDimensions.add(Integer.parseInt(dim));
                }
            }
            return this.spawnDimensions;
        }
    }

    public static class ConfigMysticalWorldOreDebugging {
        @Config.Comment(value={"Enable debugging at all. Specific ores will need to be enabled individually before any messages will be printed."})
        @Config.Name(value="Enable Debugging")
        public boolean enableDebugging = false;
        @Config.Comment(value={"Enable debugging to the standard log file. Useful if you do not generate or have access to debug.log. WARNING: WILL OVERLY INFLATE YOUR STANDARD LOG FILE. ONLY ENABLE IF NEEDED."})
        @Config.Name(value="Enable Info Debugging (ONLY IF NEEDED)")
        public boolean enableInfoDebugging = false;
        @Config.Comment(value={"Enable the debugging of Amethyst Ore"})
        @Config.Name(value="Debug Amethyst Ore")
        public boolean debugAmethyst = false;
        @Config.Comment(value={"Enable the debugging of Copper Ore"})
        @Config.Name(value="Debug Copper Ore")
        public boolean debugCopper = false;
        @Config.Comment(value={"Enable the debugging of Silver Ore"})
        @Config.Name(value="Debug Silver Ore")
        public boolean debugSilver = false;
    }

    public static class ConfigMysticalWorldToolEnable {
        @Config.Comment(value={"Set to false to disable silver tool recipes entirely"})
        @Config.Name(value="Enable silver tools")
        public boolean enableSilver = true;
        @Config.Comment(value={"Set to false to disable copper tool recipes entirely"})
        @Config.Name(value="Enable copper tools")
        public boolean enableCopper = true;
        @Config.Comment(value={"Set to false to disable amethyst tool recipes entirely"})
        @Config.Name(value="Enable amethyst tools")
        public boolean enableAmethyst = true;
        @Config.Comment(value={"Settings for individual Amethyst tool recipes"})
        @Config.Name(value="Amethyst Tool recipes")
        public AmethystTools amethystTools = new AmethystTools();
        @Config.Comment(value={"Settings for individual Copper tool recipes"})
        @Config.Name(value="Copper Tool recipes")
        public CopperTools copperTools = new CopperTools();
        @Config.Comment(value={"Settings for individual Silver tool recipes"})
        @Config.Name(value="Silver Tool recipes")
        public SilverTools silverTools = new SilverTools();

        public static class SilverTools {
            @Config.Comment(value={"Set to false to disable the silver axe recipe"})
            @Config.Name(value="Enable silver axe")
            public boolean silverAxe = true;
            @Config.Comment(value={"Set to false to disable the silver hoe recipe"})
            @Config.Name(value="Enable silver hoe")
            public boolean silverHoe = true;
            @Config.Comment(value={"Set to false to disable the silver knife recipe"})
            @Config.Name(value="Enable silver knife")
            public boolean silverKnife = true;
            @Config.Comment(value={"Set to false to disable the silver pickaxe recipe"})
            @Config.Name(value="Enable silver pickaxe")
            public boolean silverPickaxe = true;
            @Config.Comment(value={"Set to false to disable the silver shovel recipe"})
            @Config.Name(value="Enable silver shovel")
            public boolean silverShovel = true;
            @Config.Comment(value={"Set to false to disable the silver sword recipe"})
            @Config.Name(value="Enable silver sword")
            public boolean silverSword = true;
        }

        public static class CopperTools {
            @Config.Comment(value={"Set to false to disable the copper axe recipe"})
            @Config.Name(value="Enable copper axe")
            public boolean copperAxe = true;
            @Config.Comment(value={"Set to false to disable the copper hoe recipe"})
            @Config.Name(value="Enable copper hoe")
            public boolean copperHoe = true;
            @Config.Comment(value={"Set to false to disable the copper knife recipe"})
            @Config.Name(value="Enable copper knife")
            public boolean copperKnife = true;
            @Config.Comment(value={"Set to false to disable the copper pickaxe recipe"})
            @Config.Name(value="Enable copper pickaxe")
            public boolean copperPickaxe = true;
            @Config.Comment(value={"Set to false to disable the copper shovel recipe"})
            @Config.Name(value="Enable copper shovel")
            public boolean copperShovel = true;
            @Config.Comment(value={"Set to false to disable the copper sword recipe"})
            @Config.Name(value="Enable copper sword")
            public boolean copperSword = true;
        }

        public static class AmethystTools {
            @Config.Comment(value={"Set to false to disable the amethyst axe recipe"})
            @Config.Name(value="Enable amethyst axe")
            public boolean amethystAxe = true;
            @Config.Comment(value={"Set to false to disable the amethyst hoe recipe"})
            @Config.Name(value="Enable amethyst hoe")
            public boolean amethystHoe = true;
            @Config.Comment(value={"Set to false to disable the amethyst knife recipe"})
            @Config.Name(value="Enable amethyst knife")
            public boolean amethystKnife = true;
            @Config.Comment(value={"Set to false to disable the amethyst pickaxe recipe"})
            @Config.Name(value="Enable amethyst pickaxe")
            public boolean amethystPickaxe = true;
            @Config.Comment(value={"Set to false to disable the amethyst shovel recipe"})
            @Config.Name(value="Enable amethyst shovel")
            public boolean amethystShovel = true;
            @Config.Comment(value={"Set to false to disable the amethyst sword recipe"})
            @Config.Name(value="Enable amethyst sword")
            public boolean amethystSword = true;
        }
    }

    public static class ConfigMysticalWorldSilver {
        @Config.Comment(value={"Enable Silver"})
        public boolean enableSilver = true;
        @Config.Comment(value={"Enable Tiny Dusts for Silver"})
        public boolean enableTinyDusts = true;
        @Config.Comment(value={"Enable Dusts for Silver"})
        public boolean enableDusts = true;
        @Config.Comment(value={"Enable Ores for Silver"})
        public boolean enableOres = true;
        @Config.Comment(value={"Enable Blocks for Silver"})
        public boolean enableBlocks = true;
        @Config.Comment(value={"Enable Ingots for Silver"})
        public boolean enableIngots = true;
        @Config.Comment(value={"Enable Nuggets for Silver"})
        public boolean enableNuggets = true;
    }

    public static class ConfigMysticalWorldCopper {
        @Config.Comment(value={"Enable Copper"})
        public boolean enableCopper = true;
        @Config.Comment(value={"Enable Tiny Dusts for Copper"})
        public boolean enableTinyDusts = true;
        @Config.Comment(value={"Enable Dusts for Copper"})
        public boolean enableDusts = true;
        @Config.Comment(value={"Enable Ores for Copper"})
        public boolean enableOres = true;
        @Config.Comment(value={"Enable Blocks for Copper"})
        public boolean enableBlocks = true;
        @Config.Comment(value={"Enable Ingots for Copper"})
        public boolean enableIngots = true;
        @Config.Comment(value={"Enable Nuggets for Copper"})
        public boolean enableNuggets = true;
    }

    public static class ConfigMysticalWorldAmethyst {
        @Config.Comment(value={"Enabled Amethyst"})
        public boolean enableAmethyst = true;
        @Config.Comment(value={"Enable blocks of Amethyst"})
        public boolean enableBlocks = true;
        @Config.Comment(value={"Enable gems of Amethyst"})
        public boolean enableGems = true;
        @Config.Comment(value={"Enable Amethyst ore"})
        public boolean enableOres = true;
    }

    public static class ConfigMysticalWorldIron {
        @Config.Comment(value={"Enable Tiny Dusts for Iron"})
        public boolean enableTinyDusts = true;
        @Config.Comment(value={"Enable Dusts for Iron"})
        public boolean enableDusts = true;
    }

    public static class ConfigMysticalWorldGold {
        @Config.Comment(value={"Enable Tiny Dusts for Gold"})
        public boolean enableTinyDusts = true;
        @Config.Comment(value={"Enable Dusts for Gold"})
        public boolean enableDusts = true;
    }

    public static class ConfigMysticalWorldBurntTrees {
        @Config.Comment(value={"Chance (1 in X) of burnt trees spawning; set to -1 to disable"})
        @Config.Name(value="Spawn chance")
        @Config.RangeInt(min=-1)
        public int chance = 200;
        @Config.Comment(value={"Attempts to spawn a tree per chunk"})
        @Config.Name(value="Spawn attempts")
        @Config.RangeInt(min=1)
        public int attempts = 80;
        @Config.Comment(value={"Excluded biomes types. List consisting of elements from: |SAVANNA, CONIFEROUS, JUNGLE, SPOOKY, DEAD, LUSH, NETHER, END, MUSHROOM, MAGICAL, RARE, OCEAN, RIVER, WATER, MESA, FOREST, PLAINS, MOUNTAIN, HILLS, SWAMP, SANDY, SNOWY, WASTELAND, BEACH, VOID|"})
        @Config.Name(value="Excluded biome types")
        public String[] excludedBiomes = new String[]{"VOID", "END", "WATER", "BEACH", "MESA", "MUSHROOM", "NETHER", "OCEAN", "RIVER"};
    }

    public static class ConfigMysticalWorldSilkworm {
        @Config.Comment(value={"Set to false to disable silkworms entirely"})
        public boolean enabled = true;
        @Config.Comment(value={"Set to false to disable silkworm eggs from dropping when leaves are broken"})
        public boolean leafDrops = true;
        @Config.Comment(value={"Specify a chance (1 in X) for silkworm eggs to drop when leaves are broken"})
        public int leafDropChance = 55;
        @Config.Comment(value={"Specify a chance (1 in X) for silkworm eggs used to successfully spawn a silkworm"})
        public int successChance = 2;
        @Config.Comment(value={"Specify a chance (1 in X) per chunk for a silkworm to grow (default 40, around 3-4 minutes per)"})
        public int growthChance = 85;
    }

    public static class ConfigMysticalWorldOwl {
        @Config.Comment(value={"Spawn rate of owls"})
        public int rate = 9;
        @Config.Comment(value={"Min number of owls to spawn in a group"})
        public int min = 1;
        @Config.Comment(value={"Maximum number of frogs to spawn in a group"})
        public int max = 3;
        @Config.Comment(value={"Biomes to spawn in. List consisting of elements from: |SAVANNA, CONIFEROUS, JUNGLE, SPOOKY, DEAD, LUSH, NETHER, END, MUSHROOM, MAGICAL, RARE, OCEAN, RIVER, WATER, MESA, FOREST, PLAINS, MOUNTAIN, HILLS, SWAMP, SANDY, SNOWY, WASTELAND, BEACH, VOID|"})
        public String[] biomes = new String[]{"CONIFEROUS", "SPOOKY", "MAGICAL", "FOREST", "MOUNTAIN", "SNOWY"};
    }

    public static class ConfigMysticalWorldFrog {
        @Config.Comment(value={"Spawn rate of frog"})
        public int rate = 6;
        @Config.Comment(value={"Min number of frogs to spawn in a group"})
        public int min = 2;
        @Config.Comment(value={"Maximum number of frogs to spawn in a group"})
        public int max = 4;
        @Config.Comment(value={"How often slime balls are dropped; set to -1 to disable slime ball dropping"})
        public int slimeTime = 18000;
        @Config.Comment(value={"Biomes to spawn in. List consisting of elements from: |SAVANNA, CONIFEROUS, JUNGLE, SPOOKY, DEAD, LUSH, NETHER, END, MUSHROOM, MAGICAL, RARE, OCEAN, RIVER, WATER, MESA, FOREST, PLAINS, MOUNTAIN, HILLS, SWAMP, SANDY, SNOWY, WASTELAND, BEACH, VOID|"})
        public String[] biomes = new String[]{"SWAMP", "JUNGLE", "BEACH", "RIVER"};
    }

    public static class ConfigMysticalWorldBeetle {
        @Config.Comment(value={"Spawn rate of beetle"})
        public int rate = 5;
        @Config.Comment(value={"Min number of beetles to spawn in a group"})
        public int min = 2;
        @Config.Comment(value={"Maximum number of beetles to spawn in a group"})
        public int max = 4;
        @Config.Comment(value={"Biome types to spawn in. List consisting of elements from: |SAVANNA, CONIFEROUS, JUNGLE, SPOOKY, DEAD, LUSH, NETHER, END, MUSHROOM, MAGICAL, RARE, OCEAN, RIVER, WATER, MESA, FOREST, PLAINS, MOUNTAIN, HILLS, SWAMP, SANDY, SNOWY, WASTELAND, BEACH, VOID|"})
        public String[] biomes = new String[]{"SWAMP", "JUNGLE", "FOREST", "PLAINS"};
    }

    public static class ConfigMysticalWorldFox {
        @Config.Comment(value={"Spawn rate of fox"})
        public int rate = 4;
        @Config.Comment(value={"Min number of fox to spawn in a group"})
        public int min = 1;
        @Config.Comment(value={"Maximum number of fox to spawn in a group"})
        public int max = 3;
        @Config.Comment(value={"Biomes to spawn in. List consisting of elements from: |SAVANNA, CONIFEROUS, JUNGLE, SPOOKY, DEAD, LUSH, NETHER, END, MUSHROOM, MAGICAL, RARE, OCEAN, RIVER, WATER, MESA, FOREST, PLAINS, MOUNTAIN, HILLS, SWAMP, SANDY, SNOWY, WASTELAND, BEACH, VOID|"})
        public String[] biomes = new String[]{"FOREST", "COLD", "CONIFEROUS"};
    }

    public static class ConfigMysticalWorldDeer {
        @Config.Comment(value={"Spawn rate of deer"})
        public int rate = 6;
        @Config.Comment(value={"Min number of deer to spawn in a group"})
        public int min = 2;
        @Config.Comment(value={"Maximum number of deer to spawn in a group"})
        public int max = 4;
        @Config.Comment(value={"Biomes to spawn in. List consisting of elements from: |SAVANNA, CONIFEROUS, JUNGLE, SPOOKY, DEAD, LUSH, NETHER, END, MUSHROOM, MAGICAL, RARE, OCEAN, RIVER, WATER, MESA, FOREST, PLAINS, MOUNTAIN, HILLS, SWAMP, SANDY, SNOWY, WASTELAND, BEACH, VOID|"})
        public String[] biomes = new String[]{"FOREST", "COLD", "CONIFEROUS", "PLAINS"};
    }

    public static class ConfigMysticalWorldEndermini {
        @Config.Comment(value={"Spawn rate of enderminis in the End"})
        public int rate = 50;
        @Config.Comment(value={"Min number of enderminis to spawn in a group"})
        public int min = 1;
        @Config.Comment(value={"Maximum number of enderminis to spawn in a group"})
        public int max = 1;
    }

    public static class ConfigMysticalWorldSprout {
        @Config.Comment(value={"Spawn rate of sprouts"})
        public int rate = 2;
        @Config.Comment(value={"Min number of sprouts to spawn in a group"})
        public int min = 2;
        @Config.Comment(value={"Maximum number of sprouts to spawn in a group"})
        public int max = 4;
        @Config.Comment(value={"Biomes to spawn in. List consisting of elements from: |SAVANNA, CONIFEROUS, JUNGLE, SPOOKY, DEAD, LUSH, NETHER, END, MUSHROOM, MAGICAL, RARE, OCEAN, RIVER, WATER, MESA, FOREST, PLAINS, MOUNTAIN, HILLS, SWAMP, SANDY, SNOWY, WASTELAND, BEACH, VOID|"})
        public String[] biomes = new String[]{"JUNGLE", "LUSH", "MAGICAL", "RIVER", "FOREST", "BEACH"};
    }

    public static class ConfigMysticalWorldLavaCat {
        @Config.Comment(value={"Spawn rate of lava cats"})
        public int rate = 2;
        @Config.Comment(value={"Min number of sprouts to spawn in a group"})
        public int min = 1;
        @Config.Comment(value={"Maximum number of sprouts to spawn in a group"})
        public int max = 1;
        @Config.Comment(value={"Biomes to spawn in. List consisting of elements from: |SAVANNA, CONIFEROUS, JUNGLE, SPOOKY, DEAD, LUSH, NETHER, END, MUSHROOM, MAGICAL, RARE, OCEAN, RIVER, WATER, MESA, FOREST, PLAINS, MOUNTAIN, HILLS, SWAMP, SANDY, SNOWY, WASTELAND, BEACH, VOID|"})
        public String[] biomes = new String[]{"NETHER"};
    }

    public static class ConfigMysticalWorldMobs {
        @Config.Comment(value={"Enable the spawning of Deer."})
        public boolean spawnDeer = true;
        @Config.Comment(value={"Enable the spawning of Fox."})
        public boolean spawnFox = true;
        @Config.Comment(value={"Enable the spawning of Beetle."})
        public boolean spawnBeetle = true;
        @Config.Comment(value={"Enable the spawning of Frog."})
        public boolean spawnFrog = true;
        @Config.Comment(value={"Enable the spawning of Sprouts."})
        @Config.Ignore
        public boolean spawnSprout = true;
        @Config.Comment(value={"Enable the spawning of Endermini."})
        public boolean spawnEndermini = true;
        @Config.Comment(value={"Enable the spawning of Owls."})
        public boolean spawnOwl = true;
        @Config.Comment(value={"Enable the spawning of Lava Cats"})
        public boolean spawnLavaCat = true;
    }
}

