/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.item;

import epicsquid.mysticallib.item.ItemBase;
import epicsquid.mysticalworld.config.ConfigManager;
import epicsquid.mysticalworld.entity.EntitySilkworm;
import epicsquid.mysticalworld.init.ModSounds;
import java.util.List;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ItemSilkwormEgg
extends ItemBase {
    private static ResourceLocation ENTITY_ID = new ResourceLocation("mysticalworld", "entity_silkworm");

    public ItemSilkwormEgg(String name) {
        super(name);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemstack)) {
            return EnumActionResult.FAIL;
        }
        BlockPos blockpos = pos.func_177972_a(facing);
        double d0 = this.getYOffset(worldIn, blockpos);
        boolean success = this.spawnCreature(worldIn, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + d0, (double)blockpos.func_177952_p() + 0.5);
        if (!player.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        if (success) {
            worldIn.func_184148_a(null, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, ModSounds.Silkworm.PLOP, SoundCategory.NEUTRAL, 1.0f, 1.4f + (worldIn.field_73012_v.nextFloat() - 0.5f));
        } else {
            worldIn.func_184148_a(null, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, ModSounds.Silkworm.USE_EGG, SoundCategory.NEUTRAL, 0.5f, 2.0f);
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        if (raytraceresult != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.func_178782_a();
            if (!(worldIn.func_180495_p(blockpos).func_177230_c() instanceof BlockLiquid)) {
                return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
            }
            if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, raytraceresult.field_178784_b, itemstack)) {
                boolean success = this.spawnCreature(worldIn, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                if (success) {
                    worldIn.func_184134_a((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, ModSounds.Silkworm.PLOP, SoundCategory.NEUTRAL, 1.0f, 1.4f + (worldIn.field_73012_v.nextFloat() - 0.5f), false);
                } else {
                    worldIn.func_184134_a((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, ModSounds.Silkworm.USE_EGG, SoundCategory.NEUTRAL, 0.5f, 2.0f, false);
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    private boolean spawnCreature(World worldIn, double x, double y, double z) {
        if (worldIn.field_73012_v.nextInt(ConfigManager.safeInt(ConfigManager.silkworm.successChance)) == 0) {
            ItemSilkwormEgg.doSpawnCreature(worldIn, x, y, z);
            return true;
        }
        return false;
    }

    public static void doSpawnCreature(World worldIn, double x, double y, double z) {
        EntitySilkworm entity = (EntitySilkworm)EntityList.func_188429_b((ResourceLocation)ENTITY_ID, (World)worldIn);
        entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70761_aq = entity.field_70177_z;
        entity.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entity)), null);
        entity.func_70873_a(0);
        worldIn.func_72838_d((Entity)entity);
        entity.func_70642_aH();
    }

    private double getYOffset(World p_190909_1_, BlockPos p_190909_2_) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(p_190909_2_).func_72321_a(0.0, -1.0, 0.0);
        List list = p_190909_1_.func_184144_a(null, axisalignedbb);
        if (list.isEmpty()) {
            return 0.0;
        }
        double d0 = axisalignedbb.field_72338_b;
        for (AxisAlignedBB axisalignedbb1 : list) {
            d0 = Math.max(axisalignedbb1.field_72337_e, d0);
        }
        return d0 - (double)p_190909_2_.func_177956_o();
    }
}

