/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.block;

import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.key.IBlockStateKeyGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.automation.block.BlockBaseAutomation;
import net.shadowmage.ancientwarfare.automation.render.property.AutomationProperties;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueBase;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.render.BlockStateKeyGenerator;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.ModelLoaderHelper;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public abstract class BlockTorqueBase
extends BlockBaseAutomation
implements BlockRotationHandler.IRotatableBlock {
    protected BlockTorqueBase(Material material, String regName) {
        super(material, regName);
        this.func_149711_c(2.0f);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return WorldTools.clickInteractableTileWithHand(world, pos, player, hand);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        this.addProperties(builder);
        return builder.add(new IUnlistedProperty[]{CoreProperties.UNLISTED_FACING, AutomationProperties.ACTIVE, AutomationProperties.DYNAMIC, AutomationProperties.ROTATIONS[0], AutomationProperties.ROTATIONS[1], AutomationProperties.ROTATIONS[2], AutomationProperties.ROTATIONS[3], AutomationProperties.ROTATIONS[4], AutomationProperties.ROTATIONS[5]}).build();
    }

    protected void addProperties(BlockStateContainer.Builder builder) {
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facing = WorldTools.getTile(world, pos, TileTorqueBase.class).map(TileTorqueBase::getPrimaryFacing).orElse(EnumFacing.NORTH);
        return ((IExtendedBlockState)super.getExtendedState(state, world, pos)).withProperty(CoreProperties.UNLISTED_FACING, (Object)facing);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        WorldTools.getTile(world, pos, TileTorqueBase.class).ifPresent(TileTorqueBase::onNeighborTileChanged);
        super.onNeighborChange(world, pos, neighbor);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        WorldTools.getTile((IBlockAccess)world, pos, TileTorqueBase.class).ifPresent(TileTorqueBase::onNeighborTileChanged);
        super.func_189540_a(state, world, pos, block, fromPos);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        EnumFacing facing;
        if (world.field_72995_K) {
            return false;
        }
        BlockRotationHandler.IRotatableTile tt = WorldTools.getTile((IBlockAccess)world, pos, BlockRotationHandler.IRotatableTile.class).get();
        EnumFacing rotatedFacing = facing = tt.getPrimaryFacing();
        if (axis.func_176740_k() == EnumFacing.Axis.Y || this.getRotationType() == BlockRotationHandler.RotationType.SIX_WAY) {
            rotatedFacing = facing.func_176732_a(axis.func_176740_k());
        }
        if (facing != rotatedFacing) {
            tt.setPrimaryFacing(rotatedFacing);
            return true;
        }
        return false;
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        return WorldTools.sendClientEventToTile((IBlockAccess)world, pos, id, param);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        ModelLoaderHelper.registerItem(this, "automation", "normal");
        ModelBakery.registerBlockKeyGenerator((Block)this, (IBlockStateKeyGenerator)new BlockStateKeyGenerator.Builder().addKeyProperties(CoreProperties.UNLISTED_FACING, AutomationProperties.DYNAMIC).addKeyProperties(o -> String.format("%.6f", o), AutomationProperties.ROTATIONS).build());
    }
}

