/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.block;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.generation.IBakery;
import codechicken.lib.model.bakery.key.IBlockStateKeyGenerator;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.automation.block.BlockBaseAutomation;
import net.shadowmage.ancientwarfare.automation.render.WindmillBladeRenderer;
import net.shadowmage.ancientwarfare.automation.render.property.AutomationProperties;
import net.shadowmage.ancientwarfare.automation.tile.torque.multiblock.TileWindmillBlade;
import net.shadowmage.ancientwarfare.core.render.BlockStateKeyGenerator;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.ModelLoaderHelper;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public class BlockWindmillBlade
extends BlockBaseAutomation
implements IBakeryProvider {
    public static final IUnlistedProperty<Boolean> FORMED = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)"formed"));

    public BlockWindmillBlade(String regName) {
        super(Material.field_151575_d, regName);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IUnlistedProperty[]{FORMED, AutomationProperties.IS_CONTROL, AutomationProperties.HEIGHT, AutomationProperties.ROTATION, CoreProperties.UNLISTED_HORIZONTAL_FACING, AutomationProperties.DYNAMIC}).build();
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return WindmillBladeRenderer.INSTANCE.handleState((IExtendedBlockState)state, world, pos);
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        return WorldTools.sendClientEventToTile((IBlockAccess)world, pos, id, param);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        WorldTools.getTile((IBlockAccess)world, pos, TileWindmillBlade.class).ifPresent(TileWindmillBlade::blockPlaced);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        Optional<TileWindmillBlade> te = WorldTools.getTile((IBlockAccess)world, pos, TileWindmillBlade.class);
        super.func_180663_b(world, pos, state);
        te.ifPresent(TileWindmillBlade::blockBroken);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileWindmillBlade();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 60;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 20;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        ModelLoaderHelper.registerItem(this, WindmillBladeRenderer.MODEL_LOCATION);
        ModelBakery.registerBlockKeyGenerator((Block)this, (IBlockStateKeyGenerator)new BlockStateKeyGenerator.Builder().addKeyProperties(FORMED, AutomationProperties.IS_CONTROL, AutomationProperties.HEIGHT, CoreProperties.UNLISTED_HORIZONTAL_FACING, AutomationProperties.DYNAMIC).addKeyProperties(o -> String.format("%.6f", o), AutomationProperties.ROTATION).build());
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return WindmillBladeRenderer.MODEL_LOCATION;
            }
        });
        ModelRegistryHelper.register((ModelResourceLocation)WindmillBladeRenderer.MODEL_LOCATION, (IBakedModel)new CCBakeryModel(){

            @SideOnly(value=Side.CLIENT)
            public TextureAtlasSprite func_177554_e() {
                return WindmillBladeRenderer.INSTANCE.cubeSprite;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public IBakery getBakery() {
        return WindmillBladeRenderer.INSTANCE;
    }
}

