/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.container;

import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBoundedInventory;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;

public class ContainerWorksiteInventorySideSelection
extends ContainerTileBase<TileWorksiteBoundedInventory> {
    public final HashMap<BlockRotationHandler.RelativeSide, BlockRotationHandler.RelativeSide> sideMap = new HashMap();
    private static final String MACHINE_SIDE_KEY = "machineSide";
    private static final String INVENTORY_SIDE_KEY = "inventorySide";
    private static final String ACCESS_CHANGE_KEY = "accessChange";

    public ContainerWorksiteInventorySideSelection(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        for (BlockRotationHandler.RelativeSide rSide : ((TileWorksiteBoundedInventory)this.tileEntity).getInventorySideMappings().keySet()) {
            this.sideMap.put(rSide, ((TileWorksiteBoundedInventory)this.tileEntity).getInventorySideMappings().get((Object)rSide));
        }
    }

    @Override
    public void sendInitData() {
        this.sendAccessMap();
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        this.handleAccessMapTag(tag);
        if (tag.func_74764_b("closeGUI")) {
            ((TileWorksiteBoundedInventory)this.tileEntity).onBlockClicked(this.player, null);
        }
        this.refreshGui();
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.synchAccessMap();
    }

    private void handleAccessMapTag(NBTTagCompound tag) {
        if (tag.func_74764_b("accessMap")) {
            NBTTagCompound accessTag = tag.func_74775_l("accessMap");
            int[] rMap = accessTag.func_74759_k("rMap");
            int[] rMap2 = accessTag.func_74759_k("iMap");
            for (int i = 0; i < rMap.length && i < rMap2.length; ++i) {
                BlockRotationHandler.RelativeSide rSide = BlockRotationHandler.RelativeSide.values()[rMap[i]];
                BlockRotationHandler.RelativeSide iSide = BlockRotationHandler.RelativeSide.values()[rMap2[i]];
                this.sideMap.put(rSide, iSide);
            }
        } else if (tag.func_74764_b(ACCESS_CHANGE_KEY)) {
            NBTTagCompound slotTag = tag.func_74775_l(ACCESS_CHANGE_KEY);
            BlockRotationHandler.RelativeSide machineSide = BlockRotationHandler.RelativeSide.values()[slotTag.func_74762_e(MACHINE_SIDE_KEY)];
            BlockRotationHandler.RelativeSide inventorySide = BlockRotationHandler.RelativeSide.values()[slotTag.func_74762_e(INVENTORY_SIDE_KEY)];
            this.sideMap.put(machineSide, inventorySide);
            if (!this.player.field_70170_p.field_72995_K) {
                ((TileWorksiteBoundedInventory)this.tileEntity).setInventorySideMappings(machineSide, inventorySide);
            }
        }
    }

    private void sendAccessMap() {
        int l = this.sideMap.size();
        int[] rMap = new int[l];
        int[] iMap = new int[l];
        int index = 0;
        for (BlockRotationHandler.RelativeSide rSide : this.sideMap.keySet()) {
            rMap[index] = rSide.ordinal();
            iMap[index] = this.sideMap.get((Object)rSide).ordinal();
            ++index;
        }
        NBTTagCompound accessTag = new NBTTagCompound();
        accessTag.func_74783_a("rMap", rMap);
        accessTag.func_74783_a("iMap", iMap);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("accessMap", (NBTBase)accessTag);
        this.sendDataToClient(tag);
    }

    private void synchAccessMap() {
        for (BlockRotationHandler.RelativeSide rSide : ((TileWorksiteBoundedInventory)this.tileEntity).getInventorySideMappings().keySet()) {
            BlockRotationHandler.RelativeSide rSide3;
            BlockRotationHandler.RelativeSide rSide2 = ((TileWorksiteBoundedInventory)this.tileEntity).getInventorySideMappings().get((Object)rSide);
            if (rSide2 == (rSide3 = this.sideMap.get((Object)rSide))) continue;
            this.sideMap.put(rSide, rSide2);
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound slotTag = new NBTTagCompound();
            slotTag.func_74768_a(MACHINE_SIDE_KEY, rSide.ordinal());
            slotTag.func_74768_a(INVENTORY_SIDE_KEY, rSide2.ordinal());
            tag.func_74782_a(ACCESS_CHANGE_KEY, (NBTBase)slotTag);
            this.sendDataToClient(tag);
        }
    }

    public void sendSlotChange(BlockRotationHandler.RelativeSide base, BlockRotationHandler.RelativeSide access) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound slotTag = new NBTTagCompound();
        slotTag.func_74768_a(MACHINE_SIDE_KEY, base.ordinal());
        slotTag.func_74768_a(INVENTORY_SIDE_KEY, access.ordinal());
        tag.func_74782_a(ACCESS_CHANGE_KEY, (NBTBase)slotTag);
        this.sendDataToServer(tag);
    }

    public void close() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("closeGUI", true);
        this.sendDataToServer(tag);
    }
}

