/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.render;

import codechicken.lib.render.CCModel;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.shadowmage.ancientwarfare.automation.block.BlockTorqueTransportSided;
import net.shadowmage.ancientwarfare.automation.render.TorqueTieredRenderer;
import net.shadowmage.ancientwarfare.automation.render.property.AutomationProperties;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueSidedCell;

public class TorqueTransportSidedRenderer
extends TorqueTieredRenderer<TileTorqueSidedCell> {
    protected Collection<CCModel>[] gearHeads = new Collection[6];

    protected TorqueTransportSidedRenderer() {
        super("automation/torque_transport.obj");
        this.gearHeads[0] = this.removeGroups(s -> s.startsWith("downShaft."));
        this.gearHeads[1] = this.removeGroups(s -> s.startsWith("upShaft."));
        this.gearHeads[2] = this.removeGroups(s -> s.startsWith("northShaft."));
        this.gearHeads[3] = this.removeGroups(s -> s.startsWith("southShaft."));
        this.gearHeads[4] = this.removeGroups(s -> s.startsWith("westShaft."));
        this.gearHeads[5] = this.removeGroups(s -> s.startsWith("eastShaft."));
    }

    @Override
    protected Transformation getBaseTransformation() {
        return new Translation(0.0, 0.5, 0.0);
    }

    @Override
    protected void transformMovingParts(Collection<CCModel> transformedGroups, EnumFacing frontFacing, float[] rotations, @Nullable IExtendedBlockState state) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!((Boolean)state.getValue(BlockTorqueTransportSided.CONNECTIONS[facing.ordinal()])).booleanValue()) continue;
            transformedGroups.addAll(this.rotateShaft(this.gearHeads[facing.ordinal()], facing, ((Float)state.getValue(AutomationProperties.ROTATIONS[facing.ordinal()])).floatValue()));
        }
    }

    private Collection<CCModel> rotateShaft(Collection<CCModel> groups, EnumFacing facing, float rotation) {
        return groups.stream().map(m -> this.rotateShaftPart((CCModel)m, facing, rotation)).collect(Collectors.toSet());
    }

    private CCModel rotateShaftPart(CCModel part, EnumFacing facing, float rotation) {
        return part.copy().apply(new Rotation(facing.ordinal() % 2 == 0 ? (double)rotation : (double)(-rotation), facing.func_176740_k() == EnumFacing.Axis.X ? 1.0 : 0.0, facing.func_176740_k() == EnumFacing.Axis.Y ? 1.0 : 0.0, facing.func_176740_k() == EnumFacing.Axis.Z ? 1.0 : 0.0).at(Vector3.center));
    }

    @Override
    protected IExtendedBlockState handleAdditionalProperties(IExtendedBlockState state, TileTorqueSidedCell cell) {
        state = super.handleAdditionalProperties(state, cell);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            state = state.withProperty(BlockTorqueTransportSided.CONNECTIONS[facing.ordinal()], (Object)false);
        }
        return state;
    }
}

