/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.automation.config.AWAutomationStatics;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueBase;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;

public abstract class TileTorqueSingleCell
extends TileTorqueBase {
    private static final String CLIENT_ENERGY_TAG = "clientEnergy";
    private static final String TORQUE_ENERGY_TAG = "torqueEnergy";
    ITorque.TorqueCell torqueCell;
    double clientEnergyState;
    int clientDestEnergyState;
    double rotation;
    double lastRotationDiff;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.serverNetworkUpdate();
            this.torqueIn = this.torqueCell.getEnergy() - this.prevEnergy;
            this.torqueLoss = this.applyPowerDrain(this.torqueCell);
            this.torqueOut = this.transferPowerTo(this.getPrimaryFacing());
            this.prevEnergy = this.torqueCell.getEnergy();
        } else {
            this.clientNetworkUpdate();
            this.updateRotation();
        }
    }

    protected double applyPowerLoss() {
        return this.applyPowerDrain(this.torqueCell);
    }

    @Override
    protected void serverNetworkSynch() {
        int percent = (int)(this.torqueCell.getPercentFull() * 100.0);
        int percent2 = (int)(this.torqueOut / this.torqueCell.getMaxOutput() * 100.0);
        if ((percent = Math.max(percent, percent2)) != this.clientDestEnergyState) {
            this.clientDestEnergyState = percent;
            this.sendSideRotation(this.getPrimaryFacing(), percent);
        }
    }

    @Override
    protected void updateRotation() {
        if (this.clientEnergyState > 0.0) {
            this.lastRotationDiff = -(30.000001907348633 * this.clientEnergyState * 0.01) * 0.01745329238474369;
            this.rotation += this.lastRotationDiff;
            this.rotation %= 6.2831854820251465;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void clientNetworkUpdate() {
        if (!MathHelper.func_180185_a((float)((float)this.clientEnergyState), (float)this.clientDestEnergyState)) {
            if (this.networkUpdateTicks > 0) {
                this.clientEnergyState += ((double)this.clientDestEnergyState - this.clientEnergyState) / (double)this.networkUpdateTicks;
                --this.networkUpdateTicks;
            } else {
                this.clientEnergyState = this.clientDestEnergyState;
            }
        }
    }

    @Override
    protected void handleClientRotationData(EnumFacing side, int value) {
        if (side == this.orientation) {
            this.clientDestEnergyState = value;
            this.networkUpdateTicks = AWAutomationStatics.energyMinNetworkUpdateFrequency;
        }
    }

    @Override
    public double getMaxTorque(@Nullable EnumFacing from) {
        return this.torqueCell.getMaxEnergy();
    }

    @Override
    public double getTorqueStored(@Nullable EnumFacing from) {
        return this.torqueCell.getEnergy();
    }

    @Override
    public double addTorque(@Nullable EnumFacing from, double energy) {
        return this.torqueCell.addEnergy(energy);
    }

    @Override
    public double drainTorque(EnumFacing from, double energy) {
        return this.torqueCell.drainEnergy(energy);
    }

    @Override
    public double getMaxTorqueOutput(EnumFacing from) {
        return this.canOutputTorque(from) ? this.torqueCell.getMaxTickOutput() : 0.0;
    }

    @Override
    public double getMaxTorqueInput(@Nullable EnumFacing from) {
        return this.canInputTorque(from) ? this.torqueCell.getMaxTickInput() : 0.0;
    }

    @Override
    public boolean useOutputRotation(@Nullable EnumFacing from) {
        return true;
    }

    @Override
    protected double getTotalTorque() {
        return this.torqueCell.getEnergy();
    }

    @Override
    public boolean canOutputTorque(EnumFacing towards) {
        return towards == this.orientation;
    }

    @Override
    public boolean canInputTorque(@Nullable EnumFacing from) {
        return from == this.orientation.func_176734_d();
    }

    @Override
    public float getClientOutputRotation(EnumFacing from, float delta) {
        return from == this.orientation ? this.getRenderRotation(this.rotation, this.lastRotationDiff, delta) : 0.0f;
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.clientDestEnergyState = tag.func_74762_e(CLIENT_ENERGY_TAG);
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        tag.func_74768_a(CLIENT_ENERGY_TAG, this.clientDestEnergyState);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.torqueCell.setEnergy(tag.func_74769_h(TORQUE_ENERGY_TAG));
        this.clientDestEnergyState = tag.func_74762_e(CLIENT_ENERGY_TAG);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74780_a(TORQUE_ENERGY_TAG, this.torqueCell.getEnergy());
        tag.func_74768_a(CLIENT_ENERGY_TAG, this.clientDestEnergyState);
        return tag;
    }
}

