/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.warehouse2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.automation.container.ContainerWarehouseControl;
import net.shadowmage.ancientwarfare.automation.container.ContainerWarehouseCraftingStation;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.IControlledTile;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.IControllerTile;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.IWarehouseStorageTile;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseInterface;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseStockViewer;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.WarehouseDebugger;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.WarehouseStorageFilter;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.WarehouseStorageMap;
import net.shadowmage.ancientwarfare.automation.tile.worksite.IWorksiteAction;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBounded;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public abstract class TileWarehouseBase
extends TileWorksiteBounded
implements IControllerTile {
    private boolean init;
    private boolean shouldRecount;
    private final Set<TileWarehouseStockViewer> stockViewers = new HashSet<TileWarehouseStockViewer>();
    private final Set<TileWarehouseInterface> interfaceTiles = new HashSet<TileWarehouseInterface>();
    private final Set<IWarehouseStorageTile> storageTiles = new HashSet<IWarehouseStorageTile>();
    private final Set<TileWarehouseInterface> interfacesToFill = new HashSet<TileWarehouseInterface>();
    private final Set<TileWarehouseInterface> interfacesToEmpty = new HashSet<TileWarehouseInterface>();
    protected WarehouseStorageMap storageMap = new WarehouseStorageMap();
    protected ItemQuantityMap cachedItemMap = new ItemQuantityMap();
    private final Set<ContainerWarehouseControl> viewers = new HashSet<ContainerWarehouseControl>();
    private final Set<ContainerWarehouseCraftingStation> craftingViewers = new HashSet<ContainerWarehouseCraftingStation>();
    private static final IWorksiteAction EMPTY_ACTION = e -> IWorkSite.WorksiteImplementation.getEnergyPerActivation(e) / 4.0;
    private static final IWorksiteAction FILL_ACTION = e -> IWorkSite.WorksiteImplementation.getEnergyPerActivation(e) / 4.0;

    public int getMaxStorage() {
        int max = 0;
        for (IWarehouseStorageTile t : this.storageTiles) {
            max += t.getStorageAdditionSize();
        }
        return max;
    }

    @Override
    public void onBoundsAdjusted() {
        BlockPos max = this.getWorkBoundsMax();
        this.setWorkBoundsMax(max.func_177981_b(this.getWorkBoundsMin().func_177956_o() + this.getBoundsMaxHeight() - max.func_177956_o()));
        this.interfacesToEmpty.clear();
        this.interfacesToFill.clear();
        for (TileWarehouseInterface tileWarehouseInterface : this.interfaceTiles) {
            tileWarehouseInterface.setController(null);
        }
        this.interfaceTiles.clear();
        for (TileWarehouseStockViewer tileWarehouseStockViewer : this.stockViewers) {
            tileWarehouseStockViewer.setController(null);
        }
        this.stockViewers.clear();
        for (IWarehouseStorageTile iWarehouseStorageTile : this.storageTiles) {
            if (!(iWarehouseStorageTile instanceof IControlledTile)) continue;
            ((IControlledTile)((Object)iWarehouseStorageTile)).setController(null);
        }
        this.storageTiles.clear();
        this.storageMap = new WarehouseStorageMap();
        this.cachedItemMap.clear();
        this.scanForInitialTiles();
        WarehouseDebugger.reinitializeItemCounts(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public boolean userAdjustableBlocks() {
        return false;
    }

    @Override
    public int getBoundsMaxHeight() {
        return 3;
    }

    public abstract void handleSlotClick(EntityPlayer var1, ItemStack var2, boolean var3, boolean var4);

    public void changeCachedQuantity(ItemStack filter, int change) {
        if (change > 0) {
            this.cachedItemMap.addCount(filter, change);
        } else {
            this.cachedItemMap.decreaseCount(filter, -change);
        }
        this.updateViewers();
        WarehouseDebugger.changeItemQuantity(this.field_145850_b, this.field_174879_c, filter, change);
    }

    private boolean tryEmptyInterfaces() {
        ArrayList<TileWarehouseInterface> toEmpty = new ArrayList<TileWarehouseInterface>(this.interfacesToEmpty);
        for (TileWarehouseInterface tile : toEmpty) {
            if (!this.tryEmptyTile(tile)) continue;
            tile.recalcRequests();
            return true;
        }
        return false;
    }

    private boolean tryEmptyTile(TileWarehouseInterface tile) {
        List<TileWarehouseInterface.InterfaceEmptyRequest> reqs = tile.getEmptyRequests();
        for (TileWarehouseInterface.InterfaceEmptyRequest req : reqs) {
            if (!this.tryRemoveFromRequest(tile, req)) continue;
            return true;
        }
        return false;
    }

    private boolean tryRemoveFromRequest(TileWarehouseInterface tile, TileWarehouseInterface.InterfaceEmptyRequest request) {
        IItemHandler inventory = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        ItemStack stack = inventory.getStackInSlot(request.slotNum);
        if (stack.func_190926_b()) {
            return false;
        }
        int toMove = request.count;
        List<IWarehouseStorageTile> potentialStorage = this.storageMap.getDestinations(stack);
        for (IWarehouseStorageTile dest : potentialStorage) {
            int stackMove;
            int moved = dest.insertItem(stack, stackMove = toMove > stack.func_190916_E() ? stack.func_190916_E() : toMove);
            if (moved > 0) {
                ItemStack filter = stack.func_77946_l();
                filter.func_190920_e(1);
                this.changeCachedQuantity(filter, moved);
            }
            toMove -= moved;
            if (!inventory.extractItem(request.slotNum, moved, false).func_190926_b()) {
                return true;
            }
            if (toMove > 0) continue;
            break;
        }
        return false;
    }

    private boolean tryFillInterfaces() {
        ArrayList<TileWarehouseInterface> toFill = new ArrayList<TileWarehouseInterface>(this.interfacesToFill);
        for (TileWarehouseInterface tile : toFill) {
            if (!this.tryFillTile(tile)) continue;
            tile.recalcRequests();
            return true;
        }
        return false;
    }

    private boolean tryFillTile(TileWarehouseInterface tile) {
        List<TileWarehouseInterface.InterfaceFillRequest> reqs = tile.getFillRequests();
        for (TileWarehouseInterface.InterfaceFillRequest req : reqs) {
            if (!this.tryFillFromRequest(tile, req)) continue;
            return true;
        }
        return false;
    }

    private boolean tryFillFromRequest(TileWarehouseInterface tile, TileWarehouseInterface.InterfaceFillRequest request) {
        List<IWarehouseStorageTile> potentialStorage = this.storageMap.getDestinations();
        IItemHandler inventory = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        int remainingToTake = request.requestAmount;
        for (IWarehouseStorageTile source : potentialStorage) {
            int found = source.getQuantityStored(request.requestedItem);
            if (found <= 0) continue;
            ItemStack stack = request.requestedItem.func_77946_l();
            int countToTake = Math.min(Math.min(stack.func_77976_d(), found), remainingToTake);
            stack.func_190920_e(countToTake);
            if (!(stack = InventoryTools.mergeItemStack(inventory, stack)).func_190926_b() && stack.func_190916_E() == countToTake) continue;
            int moved = stack.func_190926_b() ? countToTake : countToTake - stack.func_190916_E();
            source.extractItem(request.requestedItem, moved);
            this.cachedItemMap.decreaseCount(request.requestedItem, moved);
            this.updateViewers();
            if ((remainingToTake -= moved) > 0) continue;
            return true;
        }
        return remainingToTake != request.requestAmount;
    }

    public final void getItems(ItemQuantityMap map) {
        map.addAll(this.cachedItemMap);
    }

    public final void clearItemCache() {
        this.cachedItemMap.clear();
    }

    public final void addItemsToCache(ItemQuantityMap map) {
        this.cachedItemMap.addAll(map);
    }

    @Override
    protected Optional<IWorksiteAction> getNextAction() {
        if (!this.interfacesToEmpty.isEmpty()) {
            return Optional.of(EMPTY_ACTION);
        }
        if (!this.interfacesToFill.isEmpty()) {
            return Optional.of(FILL_ACTION);
        }
        return Optional.empty();
    }

    @Override
    protected boolean processAction(IWorksiteAction action) {
        if (action == EMPTY_ACTION) {
            return this.tryEmptyInterfaces();
        }
        if (action == FILL_ACTION) {
            return this.tryFillInterfaces();
        }
        return false;
    }

    @Override
    protected final void updateWorksite() {
        if (!this.init) {
            this.scanForInitialTiles();
        }
        if (this.shouldRecount) {
            this.shouldRecount = false;
            this.recountInventory();
        }
    }

    private void scanForInitialTiles() {
        BlockPos max = this.getWorkBoundsMax();
        BlockPos min = this.getWorkBoundsMin();
        List<TileEntity> tiles = WorldTools.getTileEntitiesInArea(this.field_145850_b, min.func_177958_n() - 1, min.func_177956_o(), min.func_177952_p() - 1, max.func_177958_n() + 1, max.func_177956_o(), max.func_177952_p() + 1);
        for (TileEntity te : tiles) {
            if (!(te instanceof IControlledTile) || ((IControlledTile)te).getController().isPresent() || !((IControlledTile)te).isValidController(this)) continue;
            this.addControlledTile((IControlledTile)te);
        }
        this.init = true;
    }

    private void recountInventory() {
        this.cachedItemMap.clear();
        for (IWarehouseStorageTile tile : this.storageTiles) {
            tile.addItems(this.cachedItemMap);
        }
    }

    public final void addViewer(ContainerWarehouseControl viewer) {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        this.viewers.add(viewer);
    }

    public final void addCraftingViewer(ContainerWarehouseCraftingStation viewer) {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        this.craftingViewers.add(viewer);
    }

    public final void removeViewer(ContainerWarehouseControl viewer) {
        this.viewers.remove((Object)viewer);
    }

    public final void removeCraftingViewer(ContainerWarehouseCraftingStation viewer) {
        this.craftingViewers.remove(viewer);
    }

    public final void updateViewers() {
        for (ContainerWarehouseControl containerWarehouseControl : this.viewers) {
            containerWarehouseControl.onWarehouseInventoryUpdated();
        }
        for (TileWarehouseStockViewer tileWarehouseStockViewer : this.stockViewers) {
            tileWarehouseStockViewer.onWarehouseInventoryUpdated();
        }
        for (ContainerWarehouseCraftingStation containerWarehouseCraftingStation : this.craftingViewers) {
            containerWarehouseCraftingStation.onWarehouseInventoryUpdated();
        }
    }

    private void addStorageTile(IWarehouseStorageTile tile) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.storageTiles.contains(tile)) {
            if (tile instanceof IControlledTile) {
                ((IControlledTile)((Object)tile)).setController(this);
            }
            this.storageTiles.add(tile);
            this.storageMap.addStorageTile(tile);
            tile.addItems(this.cachedItemMap);
        }
    }

    private void removeStorageTile(IWarehouseStorageTile tile) {
        ItemQuantityMap iqm = new ItemQuantityMap();
        tile.addItems(iqm);
        this.cachedItemMap.removeAll(iqm);
        this.storageTiles.remove(tile);
        this.storageMap.removeStorageTile(tile);
        this.updateViewers();
    }

    private void addInterfaceTile(TileWarehouseInterface tile) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.interfaceTiles.contains(tile)) {
            this.interfaceTiles.add(tile);
            tile.setController(this);
            if (!tile.getEmptyRequests().isEmpty()) {
                this.interfacesToEmpty.add(tile);
            }
            if (!tile.getFillRequests().isEmpty()) {
                this.interfacesToFill.add(tile);
            }
        }
    }

    private void removeInterfaceTile(TileWarehouseInterface tile) {
        this.interfaceTiles.remove(tile);
        this.interfacesToFill.remove(tile);
        this.interfacesToEmpty.remove(tile);
    }

    public final void onIterfaceInventoryChanged(TileWarehouseInterface tile) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.interfacesToFill.remove(tile);
        this.interfacesToEmpty.remove(tile);
        if (!tile.getEmptyRequests().isEmpty()) {
            this.interfacesToEmpty.add(tile);
        }
        if (!tile.getFillRequests().isEmpty()) {
            this.interfacesToFill.add(tile);
        }
    }

    public final void onStorageFilterChanged(IWarehouseStorageTile tile, List<WarehouseStorageFilter> oldFilters, List<WarehouseStorageFilter> newFilters) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.storageMap.updateTileFilters(tile, oldFilters, newFilters);
    }

    private void addStockViewer(TileWarehouseStockViewer viewer) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.stockViewers.add(viewer);
        viewer.setController(this);
        viewer.onWarehouseInventoryUpdated();
    }

    private void removeStockViewer(TileWarehouseStockViewer tile) {
        this.stockViewers.remove(tile);
    }

    @Override
    public final void addControlledTile(IControlledTile tile) {
        if (tile instanceof IWarehouseStorageTile) {
            this.addStorageTile((IWarehouseStorageTile)((Object)tile));
        } else if (tile instanceof TileWarehouseInterface) {
            this.addInterfaceTile((TileWarehouseInterface)tile);
        } else if (tile instanceof TileWarehouseStockViewer) {
            this.addStockViewer((TileWarehouseStockViewer)tile);
        }
    }

    @Override
    public final void removeControlledTile(IControlledTile tile) {
        if (tile instanceof IWarehouseStorageTile) {
            this.removeStorageTile((IWarehouseStorageTile)((Object)tile));
        } else if (tile instanceof TileWarehouseInterface) {
            this.removeInterfaceTile((TileWarehouseInterface)tile);
        } else if (tile instanceof TileWarehouseStockViewer) {
            this.removeStockViewer((TileWarehouseStockViewer)tile);
        }
    }

    @Override
    public BlockPos getPosisition() {
        return this.func_174877_v();
    }

    @Override
    public final IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.CRAFTING;
    }

    @Override
    public final boolean onBlockClicked(EntityPlayer player, @Nullable EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 18, this.field_174879_c);
        }
        return true;
    }

    @Override
    public final boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public int getCountOf(ItemStack layoutStack) {
        return this.cachedItemMap.getCount(layoutStack);
    }

    public void decreaseCountOf(ItemStack layoutStack, int i) {
        if (this.field_145850_b.field_72995_K) {
            this.cachedItemMap.decreaseCount(layoutStack, i);
            return;
        }
        List<IWarehouseStorageTile> dest = this.storageMap.getDestinations();
        int found = 0;
        for (IWarehouseStorageTile tile : dest) {
            found = tile.getQuantityStored(layoutStack);
            if (found <= 0) continue;
            if (found > i) {
                found = i;
            }
            tile.extractItem(layoutStack, found);
            this.cachedItemMap.decreaseCount(layoutStack, found);
            if ((i -= found) > 0) continue;
            break;
        }
        this.updateViewers();
    }

    public ItemStack tryAdd(ItemStack stack) {
        List<IWarehouseStorageTile> destinations = this.storageMap.getDestinations(stack);
        for (IWarehouseStorageTile tile : destinations) {
            int moved = tile.insertItem(stack, stack.func_190916_E());
            ItemStack filter = stack.func_77946_l();
            filter.func_190920_e(1);
            this.changeCachedQuantity(filter, moved);
            stack.func_190918_g(moved);
            if (stack.func_190916_E() > 0) continue;
            break;
        }
        if (stack.func_190916_E() <= 0) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("min")) {
            this.setWorkBoundsMin(BlockPos.func_177969_a((long)tag.func_74763_f("min")));
        }
        if (tag.func_74764_b("max")) {
            this.setWorkBoundsMax(BlockPos.func_177969_a((long)tag.func_74763_f("max")));
        }
    }

    @Override
    protected void onBoundsSet() {
        this.setWorkBoundsMax(this.getWorkBoundsMax().func_177981_b(this.getWorkBoundsMin().func_177956_o() + this.getBoundsMaxHeight() - this.getWorkBoundsMax().func_177956_o()));
        BlockTools.notifyBlockUpdate(this);
    }
}

