/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.warehouse2;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.shadowmage.ancientwarfare.automation.container.ContainerWarehouseInterface;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileControlled;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.WarehouseInterfaceFilter;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.tile.IBlockBreakHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;

public class TileWarehouseInterface
extends TileControlled
implements IInteractableTile,
IBlockBreakHandler {
    private final ItemStackHandler inventory = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            TileWarehouseInterface.this.func_70296_d();
            TileWarehouseInterface.this.recalcRequests();
        }
    };
    private boolean init = false;
    private final List<InterfaceFillRequest> fillRequests = new ArrayList<InterfaceFillRequest>();
    private final List<InterfaceEmptyRequest> emptyRequests = new ArrayList<InterfaceEmptyRequest>();
    private List<WarehouseInterfaceFilter> filters = new ArrayList<WarehouseInterfaceFilter>();
    private List<ContainerWarehouseInterface> viewers = new ArrayList<ContainerWarehouseInterface>();

    public void addViewer(ContainerWarehouseInterface viewer) {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        this.viewers.add(viewer);
    }

    public void removeViewer(ContainerWarehouseInterface viewer) {
        this.viewers.remove((Object)viewer);
    }

    private void updateViewers() {
        for (ContainerWarehouseInterface v : this.viewers) {
            v.onInterfaceFiltersChanged();
        }
    }

    public List<WarehouseInterfaceFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<WarehouseInterfaceFilter> filters) {
        this.filters.clear();
        this.filters.addAll(filters);
        this.recalcRequests();
        this.updateViewers();
        this.func_70296_d();
    }

    @Override
    protected void updateTile() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.init) {
            this.init = true;
            this.recalcRequests();
        }
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player, @Nullable EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 21, this.field_174879_c);
        }
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        this.filters = NBTHelper.deserializeListFrom(tag, "filterList", WarehouseInterfaceFilter::new);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        NBTHelper.writeSerializablesTo(tag, "filterList", this.getFilters());
        return tag;
    }

    public void recalcRequests() {
        int count;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.fillRequests.clear();
        this.emptyRequests.clear();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            int max;
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            if (!this.matchesFilter(stack)) {
                this.emptyRequests.add(new InterfaceEmptyRequest(i, stack.func_190916_E()));
                continue;
            }
            count = InventoryTools.getCountOf((IItemHandler)this.inventory, stack);
            if (count <= (max = this.getFilterQuantity(stack))) continue;
            this.emptyRequests.add(new InterfaceEmptyRequest(i, count - max));
        }
        for (WarehouseInterfaceFilter filter : this.filters) {
            if (filter.getFilterItem().func_190926_b() || (count = InventoryTools.getCountOf((IItemHandler)this.inventory, filter.getFilterItem())) >= filter.getFilterQuantity()) continue;
            this.fillRequests.add(new InterfaceFillRequest(filter.getFilterItem().func_77946_l(), filter.getFilterQuantity() - count));
        }
        this.getController().ifPresent(controller -> controller.onIterfaceInventoryChanged(this));
    }

    private boolean matchesFilter(ItemStack stack) {
        if (this.filters.isEmpty()) {
            return false;
        }
        for (WarehouseInterfaceFilter filter : this.filters) {
            if (!filter.apply(stack)) continue;
            return true;
        }
        return false;
    }

    private int getFilterQuantity(ItemStack stack) {
        int qty = 0;
        for (WarehouseInterfaceFilter filter : this.filters) {
            if (!filter.apply(stack)) continue;
            qty += filter.getFilterQuantity();
        }
        return qty;
    }

    public List<InterfaceFillRequest> getFillRequests() {
        return this.fillRequests;
    }

    public List<InterfaceEmptyRequest> getEmptyRequests() {
        return this.emptyRequests;
    }

    @Override
    public void onBlockBroken(IBlockState state) {
        InventoryTools.dropItemsInWorld(this.field_145850_b, (IItemHandler)this.inventory, this.field_174879_c);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    public static class InterfaceEmptyRequest {
        final int slotNum;
        final int count;

        private InterfaceEmptyRequest(int slot, int count) {
            this.slotNum = slot;
            this.count = count;
        }
    }

    public static class InterfaceFillRequest {
        final ItemStack requestedItem;
        final int requestAmount;

        private InterfaceFillRequest(ItemStack item, int amount) {
            this.requestedItem = item;
            this.requestAmount = amount;
        }
    }
}

