/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBounded;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public abstract class TileWorksiteBoundedInventory
extends TileWorksiteBounded {
    private static final int MAIN_INVENTORY_SIZE = 27;
    public final ItemStackHandler mainInventory;
    private final Map<BlockRotationHandler.RelativeSide, IItemHandler> sideInventories = Maps.newHashMap();
    private final Map<BlockRotationHandler.RelativeSide, BlockRotationHandler.RelativeSide> inventorySideMappings = Maps.newHashMap();

    public TileWorksiteBoundedInventory() {
        this.initSideMappings();
        this.mainInventory = new ItemStackHandler(27);
        this.setSideInventory(BlockRotationHandler.RelativeSide.TOP, (IItemHandler)this.mainInventory, BlockRotationHandler.RelativeSide.BOTTOM);
    }

    private void initSideMappings() {
        for (BlockRotationHandler.RelativeSide side : BlockRotationHandler.RotationType.FOUR_WAY.getValidSides()) {
            this.inventorySideMappings.put(side, BlockRotationHandler.RelativeSide.NONE);
        }
    }

    public void setSideInventory(BlockRotationHandler.RelativeSide inventorySide, @Nullable IItemHandler handler, BlockRotationHandler.RelativeSide defaultMachineSide) {
        this.sideInventories.put(inventorySide, handler);
        this.setInventorySideMappings(defaultMachineSide, inventorySide);
    }

    public void setInventorySideMappings(BlockRotationHandler.RelativeSide machineSide, BlockRotationHandler.RelativeSide inventorySide) {
        this.inventorySideMappings.put(machineSide, inventorySide);
    }

    public Map<BlockRotationHandler.RelativeSide, IItemHandler> getSideInventories() {
        return this.sideInventories;
    }

    public Map<BlockRotationHandler.RelativeSide, BlockRotationHandler.RelativeSide> getInventorySideMappings() {
        return this.inventorySideMappings;
    }

    @Nullable
    private IItemHandler getInventoryMappedToFacing(@Nullable EnumFacing facing) {
        BlockRotationHandler.RelativeSide machineSide = BlockRotationHandler.RelativeSide.getSideViewed(BlockRotationHandler.RotationType.FOUR_WAY, this.getPrimaryFacing(), facing);
        if (this.inventorySideMappings.containsKey((Object)machineSide)) {
            return this.sideInventories.get((Object)this.inventorySideMappings.get((Object)machineSide));
        }
        return null;
    }

    @Override
    public void onBlockBroken(IBlockState state) {
        super.onBlockBroken(state);
        InventoryTools.dropItemsInWorld(this.field_145850_b, (IItemHandler)this.mainInventory, this.field_174879_c);
    }

    public void openAltGui(EntityPlayer player) {
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("mainInventory", (NBTBase)this.mainInventory.serializeNBT());
        NBTTagList sideMappings = new NBTTagList();
        for (Map.Entry<BlockRotationHandler.RelativeSide, BlockRotationHandler.RelativeSide> mapping : this.inventorySideMappings.entrySet()) {
            sideMappings.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{mapping.getKey().ordinal(), mapping.getValue().ordinal()}));
        }
        tag.func_74782_a("inventorySideMappings", (NBTBase)sideMappings);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("mainInventory")) {
            this.mainInventory.deserializeNBT(tag.func_74775_l("mainInventory"));
        }
        for (NBTBase nbt : tag.func_150295_c("inventorySideMappings", 11)) {
            NBTTagIntArray mapping = (NBTTagIntArray)nbt;
            this.setInventorySideMappings(BlockRotationHandler.RelativeSide.values()[mapping.func_150302_c()[0]], BlockRotationHandler.RelativeSide.values()[mapping.func_150302_c()[1]]);
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.getInventoryMappedToFacing(facing) != null || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        IItemHandler handler;
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (handler = this.getInventoryMappedToFacing(facing)) != null) {
            return (T)handler;
        }
        return (T)super.getCapability(capability, facing);
    }
}

