/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.compat.jei;

import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.config.Constants;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.core.compat.jei.ResearchRecipeWrapper;
import net.shadowmage.ancientwarfare.core.compat.jei.ShapedResearchRecipeWrapper;

public abstract class ResearchRecipeCategory {
    private static final int CRAFT_OUTPUT_SLOT = 0;
    private static final int CRAFT_INPUT_SLOT = 1;
    private static final int WIDTH = 116;
    private static final int HEIGHT = 54;
    private final IDrawable background;
    private final ICraftingGridHelper craftingGridHelper;
    private final IDrawable icon;

    public ResearchRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = Constants.RECIPE_GUI_VANILLA;
        this.background = guiHelper.createDrawable(location, 0, 60, 116, 54);
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
        this.icon = guiHelper.createDrawable(new ResourceLocation("ancientwarfare:textures/items/core/research_book.png"), 0, 0, 16, 16, 16, 16);
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public String getModName() {
        return "ancientwarfare";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, ResearchRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 94, 18);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 1 + x + y * 3;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        if (recipeWrapper instanceof ShapedResearchRecipeWrapper) {
            ShapedResearchRecipeWrapper shapedWrapper = (ShapedResearchRecipeWrapper)recipeWrapper;
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, shapedWrapper.getWidth(), shapedWrapper.getHeight());
        } else {
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs);
        }
        guiItemStacks.set(0, (List)outputs.get(0));
    }
}

