/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IContainerGuiCallback;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketGui;

public class ContainerBase
extends Container {
    public final EntityPlayer player;
    private IContainerGuiCallback gui;
    public int playerSlots = 0;

    public ContainerBase(EntityPlayer player) {
        this.player = player;
    }

    public final void setGui(IContainerGuiCallback gui) {
        this.gui = gui;
    }

    protected int addPlayerSlots(int tx, int ty, int gap) {
        int yPos;
        int xPos;
        int x;
        IItemHandler playerInventory = (IItemHandler)this.player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        for (x = 0; x < 9; ++x) {
            xPos = tx + x * 18;
            yPos = ty + gap + 54;
            this.func_75146_a((Slot)new SlotItemHandler(playerInventory, x, xPos, yPos));
        }
        for (int y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                int slotNum = y * 9 + x + 9;
                xPos = tx + x * 18;
                yPos = ty + y * 18;
                this.func_75146_a((Slot)new SlotItemHandler(playerInventory, slotNum, xPos, yPos));
            }
        }
        this.playerSlots = 36;
        return ty + 72 + gap;
    }

    protected int addPlayerSlots(int ty) {
        return this.addPlayerSlots(8, ty, 4);
    }

    protected int addPlayerSlots() {
        return this.addPlayerSlots(8, 156, 4);
    }

    protected final void sendDataToGui(NBTTagCompound data) {
        if (!this.player.field_70170_p.field_72995_K) {
            PacketGui pkt = new PacketGui();
            pkt.setTag("gui", data);
            NetworkHandler.sendToPlayer((EntityPlayerMP)this.player, pkt);
        }
    }

    protected void sendDataToServer(String tagName, NBTBase tag) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.func_74782_a(tagName, tag);
        this.sendDataToServer(compoundTag);
    }

    protected void sendDataToServer(NBTTagCompound data) {
        if (this.player.field_70170_p.field_72995_K) {
            PacketGui pkt = new PacketGui();
            pkt.setData(data);
            NetworkHandler.sendToServer(pkt);
        }
    }

    protected void sendDataToClient(NBTTagCompound data) {
        if (!this.player.field_70170_p.field_72995_K) {
            PacketGui pkt = new PacketGui();
            pkt.setData(data);
            NetworkHandler.sendToPlayer((EntityPlayerMP)this.player, pkt);
        }
    }

    public final void onPacketData(NBTTagCompound data) {
        if (data.func_74764_b("gui")) {
            if (this.gui != null) {
                this.gui.handlePacketData(data.func_74775_l("gui"));
            }
        } else {
            this.handlePacketData(data);
        }
    }

    public void sendInitData() {
    }

    public void handlePacketData(NBTTagCompound tag) {
    }

    public boolean func_75145_c(EntityPlayer var1) {
        return true;
    }

    public void refreshGui() {
        if (this.gui != null) {
            this.gui.refreshGui();
        }
    }

    public void removeSlots() {
        for (Slot s : this.field_75151_b) {
            if (s.field_75221_f < 0) continue;
            s.field_75221_f -= 10000;
        }
    }

    public void addSlots() {
        for (Slot s : this.field_75151_b) {
            if (s.field_75221_f >= 0) continue;
            s.field_75221_f += 10000;
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotClickedIndex) {
        return ItemStack.field_190927_a;
    }
}

