/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.entity;

import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;

public class AWEntityRegistry {
    public static final String NPC_WORKER = "aw_npc_worker";
    public static final String NPC_COMBAT = "aw_npc_combat";
    public static final String NPC_COURIER = "aw_npc_courier";
    public static final String NPC_TRADER = "aw_npc_trader";
    public static final String NPC_PRIEST = "aw_npc_priest";
    public static final String NPC_BARD = "aw_npc_bard";
    public static final String NPC_SIEGE_ENGINEER = "aw_npc_siege_engineer";
    public static final String NPC_FACTION_ARCHER = "faction.archer";
    public static final String NPC_FACTION_SOLDIER = "faction.soldier";
    public static final String NPC_FACTION_PRIEST = "faction.priest";
    public static final String NPC_FACTION_TRADER = "faction.trader";
    public static final String NPC_FACTION_COMMANDER = "faction.leader";
    public static final String NPC_FACTION_CAVALRY = "faction.cavalry";
    public static final String NPC_FACTION_MOUNTED_ARCHER = "faction.mounted_archer";
    public static final String NPC_FACTION_CIVILIAN_MALE = "faction.civilian.male";
    public static final String NPC_FACTION_ARCHER_ELITE = "faction.archer.elite";
    public static final String NPC_FACTION_SOLDIER_ELITE = "faction.soldier.elite";
    public static final String NPC_FACTION_LEADER_ELITE = "faction.leader.elite";
    public static final String NPC_FACTION_CIVILIAN_FEMALE = "faction.civilian.female";
    public static final String NPC_FACTION_BARD = "faction.bard";
    public static final String NPC_FACTION_SIEGE_ENGINEER = "faction.siege_engineer";
    public static final String VEHICLE = "vehicle";
    public static final String MISSILE = "missile";
    public static final String AW_GATES = "aw_gate";

    private AWEntityRegistry() {
    }

    public static void registerEntity(EntityDeclaration reg) {
        ResourceLocation registryName = new ResourceLocation(reg.modID, reg.entityName);
        if (!ForgeRegistries.ENTITIES.containsKey(registryName)) {
            EntityRegistry.registerModEntity((ResourceLocation)registryName, (Class)reg.entityClass, (String)reg.entityName, (int)reg.id, (Object)reg.mod(), (int)reg.trackingRange(), (int)reg.updateFrequency(), (boolean)reg.sendsVelocityUpdates());
        }
    }

    public static abstract class EntityDeclaration {
        private final Class<? extends Entity> entityClass;
        private final String entityName;
        private final int id;
        private final String modID;

        public EntityDeclaration(Class<? extends Entity> entityClass, String entityName, int id, String modID) {
            this.entityClass = entityClass;
            this.entityName = entityName;
            this.id = id;
            this.modID = modID;
        }

        protected Entity createEntity(World world) {
            try {
                return this.entityClass.getConstructor(World.class).newInstance(world);
            }
            catch (Exception e) {
                AncientWarfareCore.LOG.error("Couldn't create entity:" + e.getMessage());
                return null;
            }
        }

        public String name() {
            return this.entityName;
        }

        public abstract Object mod();

        public abstract int trackingRange();

        public abstract int updateFrequency();

        public abstract boolean sendsVelocityUpdates();

        public Class<? extends Entity> getEntityClass() {
            return this.entityClass;
        }
    }
}

