/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;

public class GuiSelectFromList<T>
extends GuiContainerBase {
    private final GuiContainerBase parent;
    private T entry;
    private final Function<T, String> getDisplayName;
    private final Supplier<List<T>> getList;
    private Consumer<T> setEntry;
    private CompositeScrolled area;
    private Text selectionLabel;
    private boolean showFilter;

    public GuiSelectFromList(GuiContainerBase parent, @Nullable T entry, Function<T, String> getDisplayName, Supplier<List<T>> getList, Consumer<T> setEntry) {
        this(parent, entry, getDisplayName, getList, setEntry, true);
    }

    public GuiSelectFromList(GuiContainerBase parent, @Nullable T entry, Function<T, String> getDisplayName, Supplier<List<T>> getList, Consumer<T> setEntry, boolean showFilter) {
        this(parent, entry, getDisplayName, getList, setEntry, showFilter, (ContainerBase)((Object)parent.getContainer()));
    }

    public GuiSelectFromList(GuiContainerBase parent, @Nullable T entry, Function<T, String> getDisplayName, Supplier<List<T>> getList, Consumer<T> setEntry, boolean showFilter, ContainerBase container) {
        super(container);
        this.parent = parent;
        this.entry = entry;
        this.getDisplayName = getDisplayName;
        this.getList = getList;
        this.setEntry = setEntry;
        this.showFilter = showFilter;
    }

    @Override
    public void initElements() {
        if (this.showFilter) {
            this.selectionLabel = new Text(8, 30, 240, this.getDisplayName.apply(this.entry), this){

                @Override
                protected void handleKeyInput(int keyCode, char ch) {
                    String old = this.getText();
                    super.handleKeyInput(keyCode, ch);
                    String text = this.getText();
                    if (!text.equals(old)) {
                        GuiSelectFromList.this.refreshGui();
                    }
                }
            };
            Listener l = new Listener(4){

                @Override
                public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                    if (evt.mButton == 1 && widget.isMouseOverElement(evt.mx, evt.my)) {
                        ((Text)widget).setText("");
                        GuiSelectFromList.this.refreshGui();
                    }
                    return false;
                }
            };
            this.selectionLabel.addNewListener(l);
            this.addGuiElement(this.selectionLabel);
        }
        this.area = new CompositeScrolled(this, 0, 40, 256, 200);
        this.addGuiElement(this.area);
    }

    @Override
    public void setupElements() {
        this.area.clearElements();
        int totalHeight = 8;
        for (final T listEntry : this.getFilteredList()) {
            Button button = new Button(8, totalHeight, 232, 12, this.getDisplayName.apply(listEntry)){

                @Override
                protected void onPressed() {
                    GuiSelectFromList.this.setEntry.accept(listEntry);
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiSelectFromList.this.parent);
                    GuiSelectFromList.this.parent.refreshGui();
                }
            };
            this.area.addGuiElement(button);
            totalHeight += 12;
        }
        this.area.setAreaSize(totalHeight);
    }

    private List<T> getFilteredList() {
        if (!this.showFilter) {
            return this.getList.get();
        }
        return this.getList.get().stream().filter(input -> input.toString().contains(this.selectionLabel.getText())).collect(Collectors.toList());
    }

    @Override
    protected boolean onGuiCloseRequested() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent);
        return false;
    }
}

