/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.util.RenderTools;

@SideOnly(value=Side.CLIENT)
public class Composite
extends GuiElement {
    protected List<GuiElement> elements = new ArrayList<GuiElement>();
    private GuiContainerBase gui;

    public GuiContainerBase getGui() {
        return this.gui;
    }

    public Composite(GuiContainerBase gui, int topLeftX, int topLeftY, int width, int height) {
        super(topLeftX, topLeftY, width, height);
        this.gui = gui;
        this.addDefaultListeners();
        this.keyboardInterface = true;
        this.mouseInterface = true;
    }

    protected void addDefaultListeners() {
        this.addNewListener(new Listener(-1){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                block4: {
                    block5: {
                        block3: {
                            if ((evt.type & 3) == 0) break block3;
                            for (GuiElement element : Composite.this.elements) {
                                element.handleKeyboardInput(evt);
                            }
                            break block4;
                        }
                        if ((evt.type & 0x3C) == 0) break block4;
                        if (!Composite.this.isMouseOverElement(evt.mx, evt.my)) break block5;
                        int x = evt.mx;
                        int y = evt.my;
                        for (GuiElement element : Composite.this.elements) {
                            element.handleMouseInput(evt);
                        }
                        evt.mx = x;
                        evt.my = y;
                        break block4;
                    }
                    if (evt.type != 4) break block4;
                    for (GuiElement element : Composite.this.elements) {
                        element.setSelected(false);
                    }
                }
                return true;
            }
        });
    }

    public void clearElements() {
        this.gui.onCompositeCleared(this.elements);
        this.elements.clear();
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        if (!this.isMouseOverElement(mouseX, mouseY)) {
            mouseX = Integer.MIN_VALUE;
            mouseY = Integer.MIN_VALUE;
        }
        this.setViewport();
        if (this.drawBackground()) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(backgroundTextureLocation);
            RenderTools.renderQuarteredTexture(256, 256, 0, 0, 256, 240, this.renderX, this.renderY, this.width, this.height);
        }
        for (GuiElement element : this.elements) {
            element.render(mouseX, mouseY, partialTick);
        }
        this.popViewport();
    }

    protected boolean drawBackground() {
        return true;
    }

    public void addGuiElement(GuiElement element) {
        if (!this.elements.contains(element)) {
            this.elements.add(element);
        }
    }

    protected void setViewport() {
        int x = this.renderX + this.getPaddingX();
        int y = this.renderY + this.getPaddingY();
        int w = this.width - 2 * this.getPaddingX();
        int h = this.height - 2 * this.getPaddingY();
        GuiContainerBase.pushViewport(x, y, w, h);
    }

    protected int getPaddingY() {
        return 3;
    }

    protected int getPaddingX() {
        return 3;
    }

    protected void popViewport() {
        GuiContainerBase.popViewport();
    }

    @Override
    public void updateGuiPosition(int guiLeft, int guiTop) {
        super.updateGuiPosition(guiLeft, guiTop);
        this.updateElementPositions();
    }

    protected void updateElementPositions() {
        for (GuiElement element : this.elements) {
            element.updateGuiPosition(this.renderX, this.renderY);
        }
    }

    public boolean isMouseOverSubElement(int mx, int my) {
        for (GuiElement el : this.elements) {
            if (!el.isMouseOverElement(mx, my)) continue;
            return true;
        }
        return false;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }
}

