/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.manual;

import java.util.List;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.TextureData;
import net.shadowmage.ancientwarfare.core.gui.elements.Composite;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.manual.GuiManual;
import net.shadowmage.ancientwarfare.core.gui.manual.Paging;
import net.shadowmage.ancientwarfare.core.gui.manual.elements.BaseElementWrapper;

public class Page
extends Composite {
    private static final int PADDING = 7;
    private final boolean leftPage;
    private final TextureData textureData;

    public Page(GuiContainerBase gui, int topLeftX, int topLeftY, int width, int height, TextureData textureData, boolean leftPage) {
        super(gui, topLeftX, topLeftY, width, height);
        this.textureData = textureData;
        this.leftPage = leftPage;
    }

    public static int getPadding() {
        return 7;
    }

    public void updateContentElements(List<BaseElementWrapper> contentElements) {
        this.clearElements();
        contentElements.forEach(this::addGuiElement);
        this.addPaging();
    }

    @Override
    public GuiManual getGui() {
        return (GuiManual)super.getGui();
    }

    @Override
    public void updateGuiPosition(int guiLeft, int guiTop) {
        super.updateGuiPosition(guiLeft + 7, guiTop + 7);
    }

    private void addPaging() {
        this.addGuiElement(new Paging(this.getGui(), 0, this.height - 14 - 14, this.width - 14, 14, this.textureData.getTexture(), this.leftPage));
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        for (GuiElement element : this.elements) {
            element.render(mouseX, mouseY, partialTick);
        }
    }
}

