/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.manual.elements;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.TextButton;
import net.shadowmage.ancientwarfare.core.gui.manual.GuiManual;
import net.shadowmage.ancientwarfare.core.gui.manual.IElementWrapperCreator;
import net.shadowmage.ancientwarfare.core.gui.manual.elements.BaseElementWrapper;
import net.shadowmage.ancientwarfare.core.manual.TableOfContentsElement;
import net.shadowmage.ancientwarfare.core.proxy.ClientProxy;

@SideOnly(value=Side.CLIENT)
public class TableOfContentsWrapper
extends BaseElementWrapper<TableOfContentsElement> {
    private static final int SPACING = 5;
    private final List<GuiElement> guiElements = new ArrayList<GuiElement>();

    public TableOfContentsWrapper(GuiManual gui, int topLeftY, int width, int height, TableOfContentsElement element) {
        super(gui, 0, topLeftY, width, height, element);
        int currentY = topLeftY;
        FontRenderer fontRenderer = ClientProxy.getUnicodeFontRenderer();
        int fontHeight = fontRenderer.field_78288_b;
        int itemHeight = fontHeight + 5;
        for (final TableOfContentsElement.TableOfContentsItem item : element.getItems()) {
            this.addGuiElement(new TextButton(0, currentY, fontRenderer.func_78256_a(item.getText()), fontHeight, item.getText(), Color.BLACK, Color.CYAN){

                @Override
                protected void onPressed(int mButton) {
                    TableOfContentsWrapper.this.getGui().setCurrentCategory(item.getCategory());
                }
            });
            currentY += itemHeight;
        }
        this.addNewListener(new Listener(60){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if ((evt.type & 0x3C) != 0) {
                    if (TableOfContentsWrapper.this.isMouseOverElement(evt.mx, evt.my)) {
                        int x = evt.mx;
                        int y = evt.my;
                        for (GuiElement element : TableOfContentsWrapper.this.guiElements) {
                            element.handleMouseInput(evt);
                        }
                        evt.mx = x;
                        evt.my = y;
                    } else if (evt.type == 4) {
                        for (GuiElement element : TableOfContentsWrapper.this.guiElements) {
                            element.setSelected(false);
                        }
                    }
                }
                return true;
            }
        });
    }

    private void addGuiElement(GuiElement guiElement) {
        this.guiElements.add(guiElement);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        for (GuiElement element : this.guiElements) {
            element.render(mouseX, mouseY, partialTick);
        }
    }

    @Override
    public void updateGuiPosition(int guiLeft, int guiTop) {
        super.updateGuiPosition(guiLeft, guiTop);
        this.guiElements.forEach(e -> e.updateGuiPosition(guiLeft, guiTop));
    }

    public static class Creator
    implements IElementWrapperCreator<TableOfContentsElement> {
        @Override
        public List<BaseElementWrapper<TableOfContentsElement>> construct(GuiManual gui, int topLeftY, int width, int remainingPageHeight, int emptyPageHeight, TableOfContentsElement element) {
            FontRenderer fontRenderer = ClientProxy.getUnicodeFontRenderer();
            int remainingCount = element.getItems().size();
            int remainingHeight = remainingCount * (fontRenderer.field_78288_b + 5);
            if (remainingHeight <= remainingPageHeight) {
                return ImmutableList.of((Object)new TableOfContentsWrapper(gui, topLeftY, width, remainingHeight, element));
            }
            int pageHeight = remainingPageHeight;
            ArrayList<BaseElementWrapper<TableOfContentsElement>> ret = new ArrayList<BaseElementWrapper<TableOfContentsElement>>();
            int yCoord = topLeftY;
            while (remainingCount > 0) {
                int renderCount = Math.min(remainingCount, pageHeight / (fontRenderer.field_78288_b + 5));
                TableOfContentsElement toc = new TableOfContentsElement(element.getItems().stream().skip(element.getItems().size() - remainingCount).limit(renderCount).collect(Collectors.toList()));
                ret.add(new TableOfContentsWrapper(gui, yCoord, width, renderCount * (fontRenderer.field_78288_b + 5), toc));
                remainingCount -= renderCount;
                pageHeight = emptyPageHeight;
                yCoord = 0;
            }
            return ret;
        }
    }
}

