/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.init;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.shadowmage.ancientwarfare.core.block.BlockEngineeringStation;
import net.shadowmage.ancientwarfare.core.block.BlockResearchStation;
import net.shadowmage.ancientwarfare.core.item.ItemBlockRotatableMetaTile;
import net.shadowmage.ancientwarfare.core.tile.TileEngineeringStation;
import net.shadowmage.ancientwarfare.core.tile.TileResearchStation;
import net.shadowmage.ancientwarfare.core.util.InjectionTools;

@GameRegistry.ObjectHolder(value="ancientwarfare")
@Mod.EventBusSubscriber(modid="ancientwarfare")
public class AWCoreBlocks {
    public static final Block ENGINEERING_STATION = (Block)InjectionTools.nullValue();
    public static final Block RESEARCH_STATION = (Block)InjectionTools.nullValue();

    private AWCoreBlocks() {
    }

    @SubscribeEvent
    public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new ItemBlockRotatableMetaTile(ENGINEERING_STATION));
        registry.register((IForgeRegistryEntry)new ItemBlockRotatableMetaTile(RESEARCH_STATION));
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new BlockEngineeringStation());
        AWCoreBlocks.registerTile(TileEngineeringStation.class, "engineering_station_tile");
        registry.register((IForgeRegistryEntry)new BlockResearchStation());
        AWCoreBlocks.registerTile(TileResearchStation.class, "research_station_tile");
    }

    private static void registerTile(Class<? extends TileEntity> teClass, String teId) {
        GameRegistry.registerTileEntity(teClass, (ResourceLocation)new ResourceLocation("ancientwarfare", teId));
    }
}

