/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.input;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.input.IInputCallback;
import net.shadowmage.ancientwarfare.core.input.InputCallbackDispatcher;
import net.shadowmage.ancientwarfare.core.input.ItemInputCallback;
import net.shadowmage.ancientwarfare.core.input.ItemKeyConflictContext;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class InputHandler {
    private static final String CATEGORY = "keybind.category.awCore";
    public static final KeyBinding ALT_ITEM_USE_1 = new KeyBinding("keybind.awCore.alt.item.use.1", (IKeyConflictContext)ItemKeyConflictContext.INSTANCE, 44, "keybind.category.awCore");
    public static final KeyBinding ALT_ITEM_USE_2 = new KeyBinding("keybind.awCore.alt.item.use.2", (IKeyConflictContext)ItemKeyConflictContext.INSTANCE, 45, "keybind.category.awCore");
    public static final KeyBinding ALT_ITEM_USE_3 = new KeyBinding("keybind.awCore.alt.item.use.3", (IKeyConflictContext)ItemKeyConflictContext.INSTANCE, 46, "keybind.category.awCore");
    public static final KeyBinding ALT_ITEM_USE_4 = new KeyBinding("keybind.awCore.alt.item.use.4", (IKeyConflictContext)ItemKeyConflictContext.INSTANCE, 47, "keybind.category.awCore");
    public static final KeyBinding ALT_ITEM_USE_5 = new KeyBinding("keybind.awCore.alt.item.use.5", (IKeyConflictContext)ItemKeyConflictContext.INSTANCE, 48, "keybind.category.awCore");
    private static final Set<InputCallbackDispatcher> keybindingCallbacks = new HashSet<InputCallbackDispatcher>();

    private InputHandler() {
    }

    public static void initKeyBindings() {
        ClientRegistry.registerKeyBinding((KeyBinding)ALT_ITEM_USE_1);
        ClientRegistry.registerKeyBinding((KeyBinding)ALT_ITEM_USE_2);
        ClientRegistry.registerKeyBinding((KeyBinding)ALT_ITEM_USE_3);
        ClientRegistry.registerKeyBinding((KeyBinding)ALT_ITEM_USE_4);
        ClientRegistry.registerKeyBinding((KeyBinding)ALT_ITEM_USE_5);
        InputHandler.initCallbacks();
    }

    private static void initCallbacks() {
        InputHandler.registerCallBack(ALT_ITEM_USE_1, new ItemInputCallback(IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_1));
        InputHandler.registerCallBack(ALT_ITEM_USE_2, new ItemInputCallback(IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_2));
        InputHandler.registerCallBack(ALT_ITEM_USE_3, new ItemInputCallback(IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_3));
        InputHandler.registerCallBack(ALT_ITEM_USE_4, new ItemInputCallback(IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_4));
        InputHandler.registerCallBack(ALT_ITEM_USE_5, new ItemInputCallback(IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_5));
    }

    public static void registerCallBack(KeyBinding keyBinding, IInputCallback callback) {
        Predicate<InputCallbackDispatcher> matchingKeyBinding = d -> d.getKeyBinding().equals(keyBinding);
        if (keybindingCallbacks.stream().anyMatch(matchingKeyBinding)) {
            keybindingCallbacks.stream().filter(matchingKeyBinding).findFirst().ifPresent(d -> d.addInputCallback(callback));
        } else {
            keybindingCallbacks.add(new InputCallbackDispatcher(keyBinding, callback));
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent evt) {
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityPlayerSP player = minecraft.field_71439_g;
        if (player == null) {
            return;
        }
        boolean state = Keyboard.getEventKeyState();
        if (state) {
            keybindingCallbacks.stream().filter(k -> k.getKeyBinding().func_151470_d()).forEach(InputCallbackDispatcher::onKeyPressed);
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new InputHandler());
    }
}

