/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.research;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.crafting.AWCraftingManager;
import net.shadowmage.ancientwarfare.core.registry.ResearchRegistry;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class ResearchGoal {
    private final Random random;
    private final String researchName;
    private final Set<String> dependencies;
    private final Set<Ingredient> researchResources;
    private int researchTime;
    private Set<String> resolvedFullDependencies;

    public ResearchGoal(String name, Set<String> dependencies, Set<Ingredient> researchResources, int researchTime) {
        this.researchName = name;
        this.dependencies = dependencies;
        this.researchResources = researchResources;
        this.researchTime = researchTime;
        this.random = new Random(this.researchName.hashCode());
    }

    public int getTotalResearchTime() {
        return this.researchTime;
    }

    public String getName() {
        return this.researchName;
    }

    public String getUnlocalizedName() {
        return ResearchGoal.getUnlocalizedName(this.researchName);
    }

    public static String getUnlocalizedName(String researchName) {
        return "research." + researchName;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof ResearchGoal && this.researchName.equals(((ResearchGoal)o).researchName);
    }

    public int hashCode() {
        return this.researchName.hashCode();
    }

    public NonNullList<ItemStack> getResourcesForDisplay() {
        return this.researchResources.stream().filter(i -> i.func_193365_a().length > 0).map(i -> i.func_193365_a()[this.random.nextInt(i.func_193365_a().length)]).collect(Collectors.toCollection(NonNullList::func_191196_a));
    }

    public Set<ResearchGoal> getDependencies() {
        return this.dependencies.stream().map(ResearchRegistry::getResearch).collect(Collectors.toSet());
    }

    boolean canResearch(Set<String> knownResearch) {
        Set<String> fullDependencies = ResearchGoal.resolveFullDependeciesFor(this);
        return knownResearch.containsAll(fullDependencies);
    }

    public boolean tryStart(IItemHandler handler) {
        if (!AWCoreStatics.enableResearchResourceUse) {
            return true;
        }
        NonNullList inventoryMatch = NonNullList.func_191196_a();
        IItemHandlerModifiable clonedHandler = InventoryTools.cloneItemHandler(handler);
        for (Ingredient ingredient : this.researchResources) {
            ItemStack stackMatch = AWCraftingManager.getIngredientInventoryMatch((IItemHandler)clonedHandler, ingredient);
            if (stackMatch.func_190926_b()) {
                return false;
            }
            inventoryMatch.add((Object)stackMatch);
        }
        InventoryTools.removeItems(handler, (NonNullList<ItemStack>)inventoryMatch);
        return true;
    }

    private static Set<String> resolveFullDependeciesFor(ResearchGoal goal) {
        if (goal.resolvedFullDependencies != null) {
            return goal.resolvedFullDependencies;
        }
        HashSet<String> foundDependencies = new HashSet<String>();
        LinkedList<String> openList = new LinkedList<String>();
        openList.addAll(goal.dependencies);
        while (!openList.isEmpty()) {
            String dep = (String)openList.poll();
            foundDependencies.add(dep);
            ResearchGoal g1 = ResearchRegistry.getResearch(dep);
            Set<String> gDeps = g1.dependencies;
            for (String goalName : gDeps) {
                if (foundDependencies.contains(goalName)) continue;
                foundDependencies.add(goalName);
                openList.add(goalName);
            }
        }
        goal.resolvedFullDependencies = foundDependencies;
        return foundDependencies;
    }
}

