/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.research;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketResearchInit;
import net.shadowmage.ancientwarfare.core.network.PacketResearchStart;
import net.shadowmage.ancientwarfare.core.network.PacketResearchUpdate;
import net.shadowmage.ancientwarfare.core.registry.ResearchRegistry;
import net.shadowmage.ancientwarfare.core.research.ResearchData;
import net.shadowmage.ancientwarfare.core.research.ResearchGoal;

public final class ResearchTracker {
    public static final ResearchTracker INSTANCE = new ResearchTracker();
    private final ResearchData clientData = new ResearchData("AWResearchData");

    private ResearchTracker() {
    }

    @SubscribeEvent
    public void playerLogInEvent(PlayerEvent.PlayerLoggedInEvent evt) {
        this.getResearchData(evt.player.field_70170_p).onPlayerLogin(evt.player);
        PacketResearchInit init = new PacketResearchInit(this.getResearchData(evt.player.field_70170_p));
        NetworkHandler.sendToPlayer((EntityPlayerMP)evt.player, init);
    }

    public void clearResearch(World world, String playerName) {
        if (world.field_72995_K) {
            this.clientData.clearResearchFor(playerName);
        } else {
            this.getResearchData(world).clearResearchFor(playerName);
            PacketResearchInit pkt = new PacketResearchInit(this.getResearchData(world));
            NetworkHandler.sendToAllPlayers(pkt);
        }
    }

    public void removeResearch(World world, String playerName, String research) {
        if (world.field_72995_K) {
            this.clientData.removeResearchFrom(playerName, research);
        } else {
            this.getResearchData(world).removeResearchFrom(playerName, research);
            PacketResearchInit pkt = new PacketResearchInit(this.getResearchData(world));
            NetworkHandler.sendToAllPlayers(pkt);
        }
    }

    public void fillResearch(World world, String playerName) {
        if (world.field_72995_K) {
            this.clientData.fillResearchFor(playerName);
        } else {
            this.getResearchData(world).fillResearchFor(playerName);
            PacketResearchInit pkt = new PacketResearchInit(this.getResearchData(world));
            NetworkHandler.sendToAllPlayers(pkt);
        }
    }

    public void addResearch(World world, String playerName, String research) {
        if (world.field_72995_K) {
            this.clientData.addResearchTo(playerName, research);
        } else {
            this.getResearchData(world).addResearchTo(playerName, research);
            PacketResearchUpdate pkt = new PacketResearchUpdate(playerName, research, true, true);
            NetworkHandler.sendToAllPlayers(pkt);
        }
    }

    public boolean hasPlayerCompleted(World world, String player, String research) {
        if (world.field_72995_K) {
            return this.clientData.hasPlayerCompletedResearch(player, research);
        }
        return this.getResearchData(world).hasPlayerCompletedResearch(player, research);
    }

    public boolean addResearchFromNotes(World world, String player, String research) {
        if (this.hasPlayerCompleted(world, player, research)) {
            return false;
        }
        this.addResearch(world, player, research);
        return true;
    }

    public boolean addProgressFromNotes(World world, String player, String research) {
        if (world.field_72995_K) {
            return false;
        }
        ResearchGoal goal = ResearchRegistry.getResearch(research);
        return this.getResearchData(world).addProgress(player, goal.getTotalResearchTime() / 4);
    }

    public Set<String> getCompletedResearchFor(World world, String playerName) {
        if (world.field_72995_K) {
            return this.clientData.getResearchFor(playerName);
        }
        return this.getResearchData(world).getResearchFor(playerName);
    }

    public List<String> getResearchQueueFor(World world, String playerName) {
        if (world.field_72995_K) {
            return Collections.emptyList();
        }
        return this.getResearchData(world).getQueuedResearch(playerName);
    }

    public Set<String> getResearchableGoals(World world, String playerName) {
        if (world.field_72995_K) {
            return this.clientData.getResearchableGoals(playerName);
        }
        return this.getResearchData(world).getResearchableGoals(playerName);
    }

    private ResearchData getResearchData(World world) {
        if (world.field_72995_K) {
            return this.clientData;
        }
        return AWGameData.INSTANCE.getData(world, ResearchData.class);
    }

    public void onClientResearchReceived(NBTTagCompound researchDataTag) {
        this.clientData.func_76184_a(researchDataTag);
    }

    public Optional<String> getCurrentGoal(World world, String playerName) {
        if (world.field_72995_K) {
            return this.clientData.getInProgressResearch(playerName);
        }
        return this.getResearchData(world).getInProgressResearch(playerName);
    }

    public int getProgress(World world, String playerName) {
        if (world.field_72995_K) {
            return this.clientData.getResearchProgress(playerName);
        }
        return this.getResearchData(world).getResearchProgress(playerName);
    }

    public void setProgress(World world, String playerName, int progress) {
        if (world.field_72995_K) {
            this.clientData.setCurrentResearchProgress(playerName, progress);
        } else {
            this.getResearchData(world).setCurrentResearchProgress(playerName, progress);
        }
    }

    public void removeQueuedGoal(World world, String playerName, String goal) {
        if (world.field_72995_K) {
            this.clientData.removeQueuedResearch(playerName, goal);
        } else {
            this.getResearchData(world).removeQueuedResearch(playerName, goal);
            PacketResearchUpdate pkt = new PacketResearchUpdate(playerName, goal, false, false);
            NetworkHandler.sendToAllPlayers(pkt);
        }
    }

    public void addQueuedGoal(World world, String playerName, String goal) {
        if (world.field_72995_K) {
            this.clientData.addQueuedResearch(playerName, goal);
        } else {
            this.getResearchData(world).addQueuedResearch(playerName, goal);
            PacketResearchUpdate pkt = new PacketResearchUpdate(playerName, goal, true, false);
            NetworkHandler.sendToAllPlayers(pkt);
        }
    }

    public void startResearch(World world, String playerName, String goal) {
        if (world.field_72995_K) {
            this.clientData.startResearch(playerName, goal);
        } else {
            this.getResearchData(world).startResearch(playerName, goal);
            PacketResearchStart pkt = new PacketResearchStart(playerName, goal, true);
            NetworkHandler.sendToAllPlayers(pkt);
        }
    }

    public void finishResearch(World world, String playerName, String goal) {
        if (world.field_72995_K) {
            this.clientData.finishResearch(playerName, goal);
        } else {
            this.getResearchData(world).finishResearch(playerName, goal);
            PacketResearchStart pkt = new PacketResearchStart(playerName, goal, false);
            NetworkHandler.sendToAllPlayers(pkt);
        }
    }
}

