/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;

public class EntityTools {
    private static final String FACTION_NAME_TAG = "factionName";

    private EntityTools() {
    }

    @Nullable
    public static EnumHand getHandHoldingItem(EntityLivingBase entity, Item item) {
        if (entity.func_184614_ca().func_77973_b() == item) {
            return EnumHand.MAIN_HAND;
        }
        if (entity.func_184592_cb().func_77973_b() == item) {
            return EnumHand.OFF_HAND;
        }
        return null;
    }

    public static ItemStack getItemFromEitherHand(EntityPlayer player, Class ... itemClasses) {
        for (Class itemClass : itemClasses) {
            if (itemClass.isInstance(player.func_184614_ca().func_77973_b())) {
                return player.func_184614_ca();
            }
            if (!itemClass.isInstance(player.func_184592_cb().func_77973_b())) continue;
            return player.func_184592_cb();
        }
        return ItemStack.field_190927_a;
    }

    public static String getUnlocName(String resourceLocation) {
        return EntityTools.getUnlocName(new ResourceLocation(resourceLocation));
    }

    public static String getUnlocName(ResourceLocation registryName) {
        EntityEntry e = (EntityEntry)ForgeRegistries.ENTITIES.getValue(registryName);
        return "entity." + (registryName.func_110624_b().equals("ancientwarfarenpc") ? "ancientwarfarenpc." : "") + e.getName() + ".name";
    }

    public static <T extends Entity> List<T> getEntitiesWithinBounds(World world, Class<? extends T> clazz, BlockPos p1, BlockPos p2) {
        AxisAlignedBB bb = new AxisAlignedBB(p1, p2.func_177982_a(1, 1, 1));
        return world.func_72872_a(clazz, bb);
    }

    public static void spawnEntity(World world, ResourceLocation entity, NBTTagCompound entityNBT, BlockPos pos) {
        Entity e = EntityList.func_188429_b((ResourceLocation)entity, (World)world);
        if (e == null) {
            return;
        }
        e.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        if (e instanceof EntityLiving) {
            ((EntityLiving)e).func_180482_a(world.func_175649_E(e.func_180425_c()), null);
            ((EntityLiving)e).func_70656_aK();
        }
        EntityTools.setDataFromTag(e, entityNBT);
        world.func_72838_d(e);
        EntityTools.setDataFromTag(e, entityNBT);
    }

    private static void setDataFromTag(Entity e, NBTTagCompound entityNBT) {
        NBTTagCompound temp = new NBTTagCompound();
        if (e instanceof NpcFaction && entityNBT.func_74764_b(FACTION_NAME_TAG)) {
            ((NpcFaction)e).setFactionNameAndDefaults(entityNBT.func_74779_i(FACTION_NAME_TAG));
        }
        e.func_189511_e(temp);
        Set keys = entityNBT.func_150296_c();
        for (String key : keys) {
            temp.func_74782_a(key, entityNBT.func_74781_a(key));
        }
        e.func_70020_e(temp);
    }

    public static EntityPlayer findClosestPlayer(World world, BlockPos pos, int maxSqDistance) {
        return world.field_73010_i.stream().filter(player -> player.func_174818_b(pos) < (double)maxSqDistance).findFirst().orElse(null);
    }
}

