/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import java.util.MissingResourceException;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryTools {
    private RegistryTools() {
    }

    static Block getBlock(String registryName) {
        return (Block)RegistryTools.getRegistryEntry(registryName, ForgeRegistries.BLOCKS);
    }

    public static Item getItem(String registryName) {
        return (Item)RegistryTools.getRegistryEntry(registryName, ForgeRegistries.ITEMS);
    }

    private static <T extends IForgeRegistryEntry<T>> T getRegistryEntry(String registryName, IForgeRegistry<T> registry) {
        ResourceLocation key = new ResourceLocation(registryName);
        if (!registry.containsKey(key)) {
            throw new MissingResourceException("Unable to find entry with registry name \"" + registryName + "\"", registry.getRegistrySuperType().getName(), registryName);
        }
        return (T)registry.getValue(key);
    }
}

