/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class WorldTools {
    private static final Map<Integer, Function<World, Boolean>> DIMENSION_DAY_TIMES = new HashMap<Integer, Function<World, Boolean>>();

    private WorldTools() {
    }

    public static List<TileEntity> getTileEntitiesInArea(World world, int x1, int y1, int z1, int x2, int y2, int z2) {
        if (world instanceof WorldServer) {
            ArrayList tileEntities = Lists.newArrayList();
            for (int x = x1 >> 4; x <= x2 >> 4; ++x) {
                for (int z = z1 >> 4; z <= z2 >> 4; ++z) {
                    WorldTools.addValidTilesInChunkArea(world, x1, y1, z1, x2, y2, z2, tileEntities, x, z);
                }
            }
            return tileEntities;
        }
        return Collections.emptyList();
    }

    private static void addValidTilesInChunkArea(World world, int x1, int y1, int z1, int x2, int y2, int z2, List<TileEntity> tileEntities, int x, int z) {
        Chunk chunk = world.func_72964_e(x, z);
        for (TileEntity tile : chunk.func_177434_r().values()) {
            if (tile.func_145837_r() || !WorldTools.isTileInArea(x1, y1, z1, x2, y2, z2, tile)) continue;
            tileEntities.add(tile);
        }
    }

    private static boolean isTileInArea(int x1, int y1, int z1, int x2, int y2, int z2, TileEntity tile) {
        return tile.func_174877_v().func_177958_n() >= x1 && tile.func_174877_v().func_177956_o() >= y1 && tile.func_174877_v().func_177952_p() >= z1 && tile.func_174877_v().func_177958_n() <= x2 && tile.func_174877_v().func_177956_o() <= y2 && tile.func_174877_v().func_177952_p() <= z2;
    }

    public static Optional<IItemHandler> getItemHandlerFromTile(IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return WorldTools.getTile(world, pos, TileEntity.class).map(t -> InventoryTools.getItemHandlerFrom((ICapabilityProvider)t, side)).orElse(Optional.empty());
    }

    public static boolean sendClientEventToTile(IBlockAccess world, BlockPos pos, int id, int param) {
        return WorldTools.getTile(world, pos).map(t -> t.func_145842_c(id, param)).orElse(false);
    }

    public static Optional<TileEntity> getTile(IBlockAccess world, BlockPos pos) {
        return WorldTools.getTile(world, pos, TileEntity.class);
    }

    public static <T> Optional<T> getTile(@Nullable IBlockAccess world, @Nullable BlockPos pos, Class<T> teClass) {
        if (world == null || pos == null) {
            return Optional.empty();
        }
        TileEntity te = world.func_175625_s(pos);
        if (teClass.isInstance(te)) {
            return Optional.of(teClass.cast(te));
        }
        return Optional.empty();
    }

    public static boolean clickInteractableTileWithHand(World world, BlockPos pos, EntityPlayer player, EnumHand hand) {
        return WorldTools.getTile((IBlockAccess)world, pos, IInteractableTile.class).map(t -> t.onBlockClicked(player, hand)).orElse(false);
    }

    public static void registerDimensionDaytimeLogic(int dimension, Function<World, Boolean> isDayTime) {
        DIMENSION_DAY_TIMES.put(dimension, isDayTime);
    }

    public static boolean isDaytimeInDimension(World world) {
        return DIMENSION_DAY_TIMES.getOrDefault(world.field_73011_w.getDimension(), World::func_72935_r).apply(world);
    }

    public static boolean hasItemHandler(World world, BlockPos pos) {
        return WorldTools.getTile((IBlockAccess)world, pos, TileEntity.class).map(t -> t.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).orElse(false);
    }

    public static <T extends WorldSavedData> Optional<T> getWorldSavedData(World world, Class<T> dataClazz, String name, boolean perWorldStorage) {
        MapStorage storage;
        MapStorage mapStorage = storage = perWorldStorage ? world.getPerWorldStorage() : world.func_175693_T();
        if (storage == null) {
            return Optional.empty();
        }
        WorldSavedData data = storage.func_75742_a(dataClazz, name);
        if (data == null) {
            try {
                data = (WorldSavedData)dataClazz.getConstructor(String.class).newInstance(name);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error instantiating " + dataClazz.toString() + " probably doesn't have ctor with single String parameter");
            }
            storage.func_75745_a(name, data);
        }
        return Optional.of(data);
    }
}

