/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util.parsing;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemStackMatcher
implements Predicate<ItemStack> {
    private final Item item;
    private final Predicate<Integer> metaMatches;
    @Nullable
    private final NBTTagCompound tagCompound;

    private ItemStackMatcher(Item item, Predicate<Integer> metaMatches, @Nullable NBTTagCompound tagCompound) {
        this.item = item;
        this.metaMatches = metaMatches;
        this.tagCompound = tagCompound;
    }

    @Override
    public boolean test(ItemStack input) {
        return input.func_77973_b() == this.item && this.metaMatches.test(input.func_77960_j()) && (this.tagCompound == null && !input.func_77942_o() || this.tagCompound.equals((Object)input.func_77978_p()));
    }

    public static class Builder {
        private Item item;
        private int meta = -1;
        private NBTTagCompound tagCompound = null;

        public Builder(Item item) {
            this.item = item;
        }

        public Builder setMeta(int meta) {
            this.meta = meta;
            return this;
        }

        public Builder setTagCompound(@Nullable NBTTagCompound tagCompound) {
            this.tagCompound = tagCompound;
            return this;
        }

        public ItemStackMatcher build() {
            return new ItemStackMatcher(this.item, this.meta == -1 ? i -> true : i -> i == this.meta, this.tagCompound);
        }
    }
}

