/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public abstract class NpcAI<T extends NpcBase>
extends EntityAIBase {
    public static final int NUMBER_OF_TASKS = 14;
    public static final int TASK_ATTACK = 1;
    public static final int TASK_UPKEEP = 2;
    public static final int TASK_IDLE_HUNGRY = 4;
    public static final int TASK_GO_HOME = 8;
    public static final int TASK_WORK = 16;
    public static final int TASK_PATROL = 32;
    public static final int TASK_GUARD = 64;
    public static final int TASK_FOLLOW = 128;
    public static final int TASK_WANDER = 256;
    public static final int TASK_MOVE = 512;
    public static final int TASK_ALARM = 1024;
    public static final int TASK_FLEE = 2048;
    public static final int TASK_SLEEP = 4096;
    public static final int TASK_RAIN = 8192;
    public static final int MOVE = 1;
    public static final int ATTACK = 2;
    public static final int SWIM = 4;
    public static final int HUNGRY = 8;
    public static final int MIN_RANGE = 9;
    protected int moveRetryDelay;
    protected double moveSpeed = 1.0;
    private double maxPFDist;
    private double maxPFDistSq;
    protected T npc;

    public NpcAI(T npc) {
        this.npc = npc;
        this.maxPFDist = npc.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111125_b() * 0.9;
        this.maxPFDistSq = this.maxPFDist * this.maxPFDist;
    }

    protected final void moveToEntity(Entity target, double sqDist) {
        this.moveToPosition(target.field_70165_t, target.func_174813_aQ().field_72338_b, target.field_70161_v, sqDist);
    }

    protected final void moveToPosition(int x, int y, int z, double sqDist) {
        this.moveToPosition((double)x + 0.5, (double)y, (double)z + 0.5, sqDist);
    }

    protected final void moveToPosition(BlockPos pos, double sqDist) {
        this.moveToPosition(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), sqDist);
    }

    protected final void moveToPosition(BlockPos pos, double sqDist, boolean forced) {
        this.moveRetryDelay = 0;
        this.moveToPosition(pos, sqDist);
    }

    protected final void moveToPosition(double x, double y, double z, double sqDist) {
        --this.moveRetryDelay;
        if (this.moveRetryDelay <= 0) {
            if (sqDist > this.maxPFDistSq) {
                this.moveLongDistance(x, y, z);
                this.moveRetryDelay = 60;
            } else {
                this.setPath(x, y, z);
                this.moveRetryDelay = 10;
                if (sqDist > 256.0) {
                    this.moveRetryDelay += 10;
                }
                if (sqDist > 1024.0) {
                    this.moveRetryDelay += 20;
                }
            }
        }
    }

    protected final void moveLongDistance(double x, double y, double z) {
        Vec3d vec = new Vec3d(x - ((NpcBase)this.npc).field_70165_t, y - ((NpcBase)this.npc).field_70163_u, z - ((NpcBase)this.npc).field_70161_v);
        double w = Math.sqrt(vec.field_72450_a * vec.field_72450_a + vec.field_72448_b * vec.field_72448_b + vec.field_72449_c * vec.field_72449_c);
        if (w != 0.0) {
            vec = vec.func_186678_a(1.0 / w);
        }
        vec = vec.func_186678_a(this.maxPFDist);
        vec = vec.func_72441_c(((NpcBase)this.npc).field_70165_t, ((NpcBase)this.npc).field_70163_u, ((NpcBase)this.npc).field_70161_v);
        this.setPath(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    protected final void returnHome() {
        this.setPath(this.npc.func_180486_cf());
    }

    protected final void setPath(double x, double y, double z) {
        Path path = this.trimPath(this.npc.func_70661_as().func_75488_a(x, y, z));
        this.npc.func_70661_as().func_75484_a(path, this.moveSpeed);
    }

    protected final void setPath(BlockPos pos) {
        Path path = this.trimPath(this.npc.func_70661_as().func_179680_a(pos));
        this.npc.func_70661_as().func_75484_a(path, this.moveSpeed);
    }

    protected Path trimPath(Path path) {
        if (path != null) {
            int index = path.func_75873_e();
            PathPoint pathpoint = path.func_75877_a(index);
            BlockPos blockPos = new BlockPos(pathpoint.field_75839_a, pathpoint.field_75837_b, pathpoint.field_75838_c);
            if (((NpcBase)this.npc).func_180484_a(blockPos) >= 0.0f) {
                for (int i = index + 1; i < path.func_75874_d(); ++i) {
                    pathpoint = path.func_75877_a(i);
                    BlockPos blockPos2 = new BlockPos(pathpoint.field_75839_a, pathpoint.field_75837_b, pathpoint.field_75838_c);
                    if (!(((NpcBase)this.npc).func_180484_a(blockPos2) < 0.0f)) continue;
                    path.func_75871_b(i - 1);
                    break;
                }
            } else {
                Vec3d vec = RandomPositionGenerator.func_75461_b(this.npc, (int)9, (int)9, (Vec3d)new Vec3d(((NpcBase)this.npc).field_70165_t, ((NpcBase)this.npc).field_70163_u, ((NpcBase)this.npc).field_70161_v));
                if (vec != null) {
                    return this.npc.func_70661_as().func_75488_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                }
            }
        }
        return path;
    }
}

