/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public abstract class NpcAIAttack<T extends NpcBase>
extends NpcAI<T> {
    private EntityLivingBase target;
    private int attackDelay = 35;

    public NpcAIAttack(T npc) {
        super(npc);
    }

    public boolean func_75250_a() {
        return this.npc.getIsAIEnabled() && this.npc.func_70638_az() != null && this.npc.func_70638_az().func_70089_S() && this.isTargetInRange();
    }

    public boolean func_75253_b() {
        return this.npc.getIsAIEnabled() && this.target != null && this.target.func_70089_S() && this.target.equals((Object)this.npc.func_70638_az()) && this.isTargetInRange();
    }

    public final void func_75249_e() {
        this.target = this.npc.func_70638_az();
        this.moveRetryDelay = 0;
        this.npc.addAITask(1);
        this.npc.setSwingingArms(true);
    }

    public final void func_75251_c() {
        this.target = null;
        this.moveRetryDelay = 0;
        this.npc.removeAITask(513);
        this.npc.setSwingingArms(false);
    }

    public final void func_75246_d() {
        this.npc.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
        double distanceToEntity = this.npc.func_70092_e(this.target.field_70165_t, this.target.func_174813_aQ().field_72338_b, this.target.field_70161_v);
        if (this.shouldCloseOnTarget(distanceToEntity)) {
            this.npc.addAITask(512);
            this.moveToEntity((Entity)this.target, distanceToEntity);
        } else {
            --this.attackDelay;
            this.doAttack(distanceToEntity);
        }
    }

    private boolean isTargetInRange() {
        return (double)this.npc.func_70032_d((Entity)this.npc.func_70638_az()) < this.getAdjustedTargetDistance();
    }

    private double getAdjustedTargetDistance() {
        if (this.npc.getFollowingEntity() != null) {
            return Math.max(this.getTargetDistance() / this.getDistanceToFollowingEntity(), 3.0);
        }
        return Math.max(this.getTargetDistance() / (this.getHomeDistance() / 20.0), 3.0);
    }

    private double getDistanceToFollowingEntity() {
        return Math.sqrt(this.npc.func_174818_b(this.npc.getFollowingEntity().func_180425_c()));
    }

    private double getHomeDistance() {
        return Math.sqrt(this.npc.func_174818_b(this.npc.func_180486_cf()));
    }

    private double getTargetDistance() {
        IAttributeInstance iattributeinstance = this.npc.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
    }

    protected abstract boolean shouldCloseOnTarget(double var1);

    protected abstract void doAttack(double var1);

    public final EntityLivingBase getTarget() {
        return this.target;
    }

    public final void setAttackDelay(int value) {
        this.attackDelay = value;
    }

    public final int getAttackDelay() {
        return this.attackDelay;
    }
}

