/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIAttack;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.item.IExtendedReachWeapon;

public class NpcAIAttackMeleeLongRange
extends NpcAIAttack<NpcBase> {
    private float attackReach = 2.5f;

    public NpcAIAttackMeleeLongRange(NpcBase npc) {
        super(npc);
        this.func_75248_a(3);
    }

    public void setAttackReachFromWeapon(ItemStack weapon) {
        float reach = 2.5f;
        if (weapon.func_77973_b() instanceof IExtendedReachWeapon) {
            reach = ((IExtendedReachWeapon)weapon.func_77973_b()).getReach() - 1.0f;
        }
        this.attackReach = reach;
    }

    @Override
    protected boolean shouldCloseOnTarget(double distanceToEntity) {
        double attackDistance = (double)this.npc.field_70130_N / 2.0 + (double)this.getTarget().field_70130_N / 2.0 + (double)this.attackReach;
        return distanceToEntity > attackDistance * attackDistance || !this.npc.func_70635_at().func_75522_a((Entity)this.getTarget());
    }

    @Override
    protected void doAttack(double distanceToEntity) {
        this.npc.removeAITask(512);
        if (this.getAttackDelay() <= 0) {
            this.npc.func_184609_a(EnumHand.MAIN_HAND);
            this.npc.func_70652_k((Entity)this.getTarget());
            this.setAttackDelay(this.getCoolDown());
            this.npc.addExperience(AWNPCStatics.npcXpFromAttack);
        }
    }

    private int getCoolDown() {
        int entityAttackCooldown = (int)(1.0 / this.npc.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111126_e() * 20.0);
        return entityAttackCooldown > 0 ? entityAttackCooldown : 20;
    }
}

