/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public class NpcAIDoor
extends EntityAIBase {
    private final EntityLiving theEntity;
    private final boolean close;
    private Set<BlockPos> doorPositions = new HashSet<BlockPos>();
    private static final int RECHECK_INTERVAL = 40;
    private int doorCheckCooldown = 40;

    public NpcAIDoor(EntityLiving living, boolean closeBehind) {
        this.theEntity = living;
        this.close = closeBehind;
    }

    public final boolean func_75250_a() {
        PathNavigateGround pathnavigate = (PathNavigateGround)this.theEntity.func_70661_as();
        if (!pathnavigate.func_179686_g() || pathnavigate.func_75500_f()) {
            return false;
        }
        Path path = pathnavigate.func_75505_d();
        if (path == null) {
            return false;
        }
        if (this.addDoorCloseOnThePath(path)) {
            return true;
        }
        if (!this.theEntity.field_70123_F) {
            return false;
        }
        BlockPos potentialDoorPos = new BlockPos(MathHelper.func_76128_c((double)this.theEntity.field_70165_t), MathHelper.func_76128_c((double)this.theEntity.field_70163_u), MathHelper.func_76128_c((double)this.theEntity.field_70161_v));
        return this.findDoor(potentialDoorPos) || this.findDoor(potentialDoorPos.func_177984_a());
    }

    private boolean addDoorCloseOnThePath(Path path) {
        for (int i = Math.max(path.func_75873_e() - 1, 0); i < Math.min(path.func_75873_e() + 2, path.func_75874_d()); ++i) {
            PathPoint pathpoint = path.func_75877_a(i);
            if (!(this.theEntity.func_70092_e((double)pathpoint.field_75839_a + 0.5, this.theEntity.field_70163_u, (double)pathpoint.field_75838_c + 0.5) <= 1.5)) continue;
            BlockPos potentialDoorPos = new BlockPos(pathpoint.field_75839_a, pathpoint.field_75837_b, pathpoint.field_75838_c);
            if (this.findDoor(potentialDoorPos)) {
                this.interactWithDoor(potentialDoorPos, true);
                return true;
            }
            if (!this.findDoor(potentialDoorPos.func_177984_a())) continue;
            this.interactWithDoor(potentialDoorPos.func_177984_a(), true);
            return true;
        }
        return false;
    }

    public void func_75246_d() {
        super.func_75246_d();
        this.closeTooFarAwayDoor();
        this.recheckDoorOpen();
        this.addDoorCloseOnThePath();
    }

    private void closeTooFarAwayDoor() {
        Iterator<BlockPos> it = this.doorPositions.iterator();
        while (it.hasNext()) {
            BlockPos doorPos = it.next();
            if (this.isCloseToDoor(doorPos) || this.isFriendlyInDoor(doorPos)) continue;
            it.remove();
            if (!this.close) continue;
            this.interactWithDoor(doorPos, false);
        }
    }

    private void addDoorCloseOnThePath() {
        Path path = this.theEntity.func_70661_as().func_75505_d();
        if (path == null) {
            return;
        }
        this.addDoorCloseOnThePath(path);
    }

    private void recheckDoorOpen() {
        if (this.doorCheckCooldown <= 0) {
            this.doorCheckCooldown = 40;
            this.doorPositions.forEach(doorPos -> this.interactWithDoor((BlockPos)doorPos, true));
        } else {
            --this.doorCheckCooldown;
        }
    }

    public final boolean func_75253_b() {
        return !this.doorPositions.isEmpty();
    }

    private boolean isFriendlyInDoor(BlockPos doorPos) {
        Vec3d doorCenter = new Vec3d((Vec3i)doorPos).func_72441_c(0.5, 0.5, 0.5);
        return !this.theEntity.field_70170_p.func_175647_a(NpcBase.class, new AxisAlignedBB(doorCenter.field_72450_a, doorCenter.field_72448_b, doorCenter.field_72449_c, doorCenter.field_72450_a, doorCenter.field_72448_b, doorCenter.field_72449_c).func_186662_g(2.1), n -> n != null && !n.isHostileTowards((Entity)this.theEntity)).isEmpty();
    }

    private boolean isCloseToDoor(BlockPos doorPos) {
        return doorPos.func_177957_d(this.theEntity.field_70165_t, this.theEntity.field_70163_u, this.theEntity.field_70161_v) <= 2.0;
    }

    private boolean isDoor(BlockPos potentialDoorPos) {
        IBlockState doorState = this.theEntity.field_70170_p.func_180495_p(potentialDoorPos);
        return doorState.func_177230_c() instanceof BlockDoor ? doorState.func_185904_a() == Material.field_151575_d : doorState.func_177230_c() instanceof BlockFenceGate;
    }

    private boolean findDoor(BlockPos potentialDoorPos) {
        if (this.isDoor(potentialDoorPos) && !this.doorPositions.contains(potentialDoorPos)) {
            this.doorPositions.add(potentialDoorPos);
            return true;
        }
        return false;
    }

    private void interactWithDoor(BlockPos doorPos, boolean isOpening) {
        IBlockState doorState = this.theEntity.field_70170_p.func_180495_p(doorPos);
        if (doorState.func_177230_c() instanceof BlockDoor) {
            ((BlockDoor)doorState.func_177230_c()).func_176512_a(this.theEntity.field_70170_p, doorPos, isOpening);
        } else if (doorState.func_177230_c() instanceof BlockFenceGate) {
            this.interactWithFenceGate(doorPos, isOpening, doorState);
        }
    }

    private void interactWithFenceGate(BlockPos doorPos, boolean isOpening, IBlockState doorState) {
        boolean fenceGateOpen = (Boolean)doorState.func_177229_b((IProperty)BlockFenceGate.field_176466_a);
        if (isOpening) {
            if (!fenceGateOpen) {
                EnumFacing entityFacing = EnumFacing.func_176733_a((double)this.theEntity.field_70177_z);
                this.openFenceGate(doorState, doorPos, entityFacing);
                IBlockState state = this.theEntity.field_70170_p.func_180495_p(doorPos.func_177984_a());
                if (state.func_177230_c() instanceof BlockFenceGate) {
                    this.openFenceGate(state, doorPos.func_177984_a(), entityFacing);
                }
            }
        } else {
            doorState = doorState.func_177226_a((IProperty)BlockFenceGate.field_176466_a, (Comparable)Boolean.valueOf(false));
            this.theEntity.field_70170_p.func_180501_a(doorPos, doorState, 10);
            IBlockState state = this.theEntity.field_70170_p.func_180495_p(doorPos.func_177984_a());
            if (state.func_177230_c() instanceof BlockFenceGate) {
                state = state.func_177226_a((IProperty)BlockFenceGate.field_176466_a, (Comparable)Boolean.valueOf(false));
                this.theEntity.field_70170_p.func_180501_a(doorPos.func_177984_a(), state, 10);
            }
        }
        this.theEntity.field_70170_p.func_180498_a(null, (Boolean)doorState.func_177229_b((IProperty)BlockFenceGate.field_176466_a) != false ? 1008 : 1014, doorPos, 0);
    }

    private void openFenceGate(IBlockState state, BlockPos pos, EnumFacing entityFacing) {
        IBlockState updatedState = state;
        if (updatedState.func_177229_b((IProperty)BlockFenceGate.field_185512_D) == entityFacing.func_176734_d()) {
            updatedState = updatedState.func_177226_a((IProperty)BlockFenceGate.field_185512_D, (Comparable)entityFacing);
        }
        updatedState = updatedState.func_177226_a((IProperty)BlockFenceGate.field_176466_a, (Comparable)Boolean.valueOf(true));
        this.theEntity.field_70170_p.func_180501_a(pos, updatedState, 10);
    }
}

