/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.faction;

import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIAttack;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public class NpcAIFactionRangedAttack
extends NpcAIAttack<NpcBase> {
    private final IRangedAttackMob rangedAttacker;
    private int attackDistanceSq = -1;

    public NpcAIFactionRangedAttack(NpcBase npc) {
        super(npc);
        this.rangedAttacker = (IRangedAttackMob)npc;
        this.moveSpeed = 1.0;
    }

    @Override
    protected boolean shouldCloseOnTarget(double dist) {
        return dist > this.getAttackDistanceSq() || !this.npc.func_70635_at().func_75522_a((Entity)this.getTarget());
    }

    private double getAttackDistanceSq() {
        if (this.attackDistanceSq == -1) {
            double distance = this.npc.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
            this.attackDistanceSq = (int)(distance * distance);
        }
        return this.attackDistanceSq;
    }

    @Override
    protected void doAttack(double dist) {
        double homeDist = this.npc.getDistanceSqFromHome();
        if (homeDist > 9.0 && dist < 64.0) {
            this.npc.addAITask(512);
            this.moveToPosition(this.npc.func_180486_cf(), homeDist);
        } else {
            this.npc.removeAITask(512);
            this.npc.func_70661_as().func_75499_g();
        }
        if (this.getAttackDelay() <= 0) {
            float pwr = (float)(this.getAttackDistanceSq() / dist);
            pwr = Math.min(Math.max(pwr, 0.1f), 1.0f);
            this.rangedAttacker.func_82196_d(this.getTarget(), pwr);
            this.setAttackDelay(35);
        }
    }
}

