/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.owned;

import java.util.List;
import java.util.Optional;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.owner.Owner;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcWorker;

public class NpcAIPlayerOwnedFindWorksite
extends NpcAI<NpcWorker> {
    private int lastExecuted = -1;
    private int checkFrequency = 200;
    private int range = 40;

    public NpcAIPlayerOwnedFindWorksite(NpcWorker npc) {
        super(npc);
    }

    public boolean func_75250_a() {
        if (!((NpcWorker)this.npc).getIsAIEnabled()) {
            return false;
        }
        return ((NpcWorker)this.npc).ordersStack.func_190926_b() && ((NpcWorker)this.npc).autoWorkTarget == null && (this.lastExecuted == -1 || ((NpcWorker)this.npc).field_70173_aa - this.lastExecuted > this.checkFrequency);
    }

    public boolean func_75253_b() {
        return false;
    }

    public void func_75249_e() {
        this.lastExecuted = ((NpcWorker)this.npc).field_70173_aa;
        if (((NpcWorker)this.npc).autoWorkTarget != null) {
            BlockPos pos = ((NpcWorker)this.npc).autoWorkTarget;
            Optional<IWorkSite> te = WorldTools.getTile((IBlockAccess)((NpcWorker)this.npc).field_70170_p, pos, IWorkSite.class);
            if (te.isPresent()) {
                IWorkSite site = te.get();
                if (!((NpcWorker)this.npc).canWorkAt(site.getWorkType())) {
                    ((NpcWorker)this.npc).autoWorkTarget = null;
                }
                if (((NpcWorker)this.npc).hasCommandPermissions(site.getOwner())) {
                    ((NpcWorker)this.npc).autoWorkTarget = null;
                }
                if (!site.hasWork()) {
                    ((NpcWorker)this.npc).autoWorkTarget = null;
                }
            } else {
                ((NpcWorker)this.npc).autoWorkTarget = null;
            }
        }
        if (((NpcWorker)this.npc).autoWorkTarget == null) {
            this.findWorkTarget();
        }
    }

    private void findWorkTarget() {
        int x = MathHelper.func_76128_c((double)((NpcWorker)this.npc).field_70165_t);
        int y = MathHelper.func_76128_c((double)((NpcWorker)this.npc).field_70163_u);
        int z = MathHelper.func_76128_c((double)((NpcWorker)this.npc).field_70161_v);
        List<TileEntity> tiles = WorldTools.getTileEntitiesInArea(((NpcWorker)this.npc).field_70170_p, x - this.range, y - this.range / 2, z - this.range, x + this.range, y + this.range / 2, z + this.range);
        TileEntity closestSite = null;
        double closestDist = -1.0;
        for (TileEntity te : tiles) {
            IWorkSite site;
            if (!(te instanceof IWorkSite) || (site = (IWorkSite)te).getOwner() != Owner.EMPTY && !((NpcWorker)this.npc).hasCommandPermissions(site.getOwner()) || !((NpcWorker)this.npc).canWorkAt(site.getWorkType()) || !site.hasWork()) continue;
            double dist = ((NpcWorker)this.npc).func_70092_e((double)te.func_174877_v().func_177958_n() + 0.5, te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p() + 0.5);
            if (closestDist != -1.0 && !(dist < closestDist)) continue;
            closestDist = dist;
            closestSite = te;
        }
        if (closestSite != null) {
            ((NpcWorker)this.npc).autoWorkTarget = closestSite.func_174877_v();
        }
    }
}

