/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.container;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcBase;
import net.shadowmage.ancientwarfare.npc.container.ISkinSettingsContainer;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.inventory.NpcEquipmentHandler;
import net.shadowmage.ancientwarfare.npc.skin.NpcSkinSettings;

public class ContainerNpcInventory
extends ContainerNpcBase<NpcBase>
implements ISkinSettingsContainer {
    public boolean doNotPursue;
    public boolean isArcher;
    public final int guiHeight;
    private String name;
    public NpcSkinSettings skinSettings;

    public ContainerNpcInventory(EntityPlayer player, int x, int y, int z) {
        super(player, x);
        this.isArcher = ((NpcBase)this.entity).getNpcSubType().equals("archer");
        NpcEquipmentHandler inventory = new NpcEquipmentHandler((NpcBase)this.entity);
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, 0, 8, 8));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, 2, 8, 98));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, 3, 8, 80));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, 4, 8, 62));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, 5, 8, 44));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, 6, 44, 62));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, 7, 44, 44));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, 1, 8, 26));
        this.guiHeight = this.addPlayerSlots(124) + 8;
        this.name = ((NpcBase)this.entity).func_95999_t();
        this.doNotPursue = ((NpcBase)this.entity).getDoNotPursue();
        this.skinSettings = ((NpcBase)this.entity).getSkinSettings();
    }

    public void sendChangesToServer() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("donotpursue", this.doNotPursue);
        this.sendDataToServer(tag);
    }

    @Override
    public void sendInitData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("donotpursue", this.doNotPursue);
        this.sendDataToClient(tag);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("customName")) {
            this.name = tag.func_74779_i("customName");
        }
        if (this.entity != null && !((NpcBase)this.entity).field_70128_L) {
            if (tag.func_74764_b("repack")) {
                ((NpcBase)this.entity).repackEntity(this.player);
            } else if (tag.func_74764_b("setHome")) {
                ((NpcBase)this.entity).setHomeAreaAtCurrentPosition();
            } else if (tag.func_74764_b("clearHome")) {
                ((NpcBase)this.entity).func_110177_bN();
            } else if (tag.func_74764_b("togglefollow")) {
                if (((NpcBase)this.entity).getFollowingEntity() != null && ((NpcBase)this.entity).getFollowingEntity().func_70005_c_().equals(this.player.func_70005_c_())) {
                    ((NpcBase)this.entity).clearFollowingEntity();
                } else {
                    ((NpcBase)this.entity).setFollowingEntity((EntityLivingBase)this.player);
                }
            }
            if (tag.func_74764_b("donotpursue")) {
                this.doNotPursue = tag.func_74767_n("donotpursue");
            }
            if (tag.func_74764_b("skinSettings")) {
                this.skinSettings = NpcSkinSettings.deserializeNBT(tag.func_74775_l("skinSettings")).minimizeData();
                ((NpcBase)this.entity).setSkinSettings(this.skinSettings);
            }
        }
        this.refreshGui();
    }

    public void handleNpcNameUpdate(String newName) {
        this.name = newName;
        if (this.name == null) {
            this.name = "";
        }
    }

    @Override
    public void handleNpcSkinUpdate() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("skinSettings", (NBTBase)this.skinSettings.serializeNBT());
        this.sendDataToServer(tag);
    }

    public void func_75134_a(EntityPlayer p_75134_1_) {
        super.func_75134_a(p_75134_1_);
        ((NpcBase)this.entity).func_96094_a(this.name);
        ((NpcBase)this.entity).setSkinSettings(this.skinSettings);
        ((NpcBase)this.entity).setDoNotPursue(this.doNotPursue);
    }

    public void setName() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("customName", this.name);
        this.sendDataToServer(tag);
    }

    @Override
    public NpcSkinSettings getSkinSettings() {
        return this.skinSettings;
    }

    @Override
    public void setSkinSettings(NpcSkinSettings skinSettings) {
        this.skinSettings = skinSettings;
    }
}

