/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.container;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;
import net.shadowmage.ancientwarfare.npc.tile.TileTownHall;

public class ContainerTownHall
extends ContainerTileBase<TileTownHall> {
    List<TileTownHall.NpcDeathEntry> deathList = new ArrayList<TileTownHall.NpcDeathEntry>();

    public ContainerTownHall(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        IItemHandler handler = (IItemHandler)((TileTownHall)this.tileEntity).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < handler.getSlots(); ++i) {
            int xPos = i % 9 * 18 + 8;
            int yPos = i / 9 * 18 + 8 + 16;
            this.func_75146_a((Slot)new SlotItemHandler(handler, i, xPos, yPos));
        }
        this.addPlayerSlots(86);
        if (!player.field_70170_p.field_72995_K) {
            this.deathList.addAll(((TileTownHall)this.tileEntity).getDeathList());
            ((TileTownHall)this.tileEntity).addViewer(this);
        }
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("deathList")) {
            this.deathList.clear();
            NBTTagList list = tag.func_150295_c("deathList", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.deathList.add(new TileTownHall.NpcDeathEntry(list.func_150305_b(i)));
            }
            this.refreshGui();
        } else if (tag.func_74764_b("clear")) {
            ((TileTownHall)this.tileEntity).clearDeathNotices();
        }
        if (tag.func_74764_b("range")) {
            ((TileTownHall)this.tileEntity).setRange(tag.func_74762_e("range"));
            this.refreshGui();
        }
        if (tag.func_74764_b("name")) {
            ((TileTownHall)this.tileEntity).name = tag.func_74779_i("name");
            this.refreshGui();
        }
        if (!((TileTownHall)this.tileEntity).func_145831_w().field_72995_K) {
            ((TileTownHall)this.tileEntity).func_70296_d();
        }
    }

    @Override
    public void sendInitData() {
        this.sendTownHallDataToClient(false);
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        ((TileTownHall)this.tileEntity).removeViewer(this);
    }

    public void onTownHallDeathListUpdated() {
        this.deathList.clear();
        this.deathList.addAll(((TileTownHall)this.tileEntity).getDeathList());
        this.sendTownHallDataToClient(true);
    }

    public void setRange(int value) {
        ((TileTownHall)this.tileEntity).setRange(value);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("range", value);
        this.sendDataToServer(tag);
    }

    public void setName(String name) {
        ((TileTownHall)this.tileEntity).name = name;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("name", name);
        this.sendDataToServer(tag);
    }

    public void teleportPlayer(String playerName) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("playerName", playerName);
        this.sendDataToServer(tag);
    }

    public void clearList() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("clear", true);
        this.sendDataToServer(tag);
    }

    private void sendTownHallDataToClient(boolean onlyDeathList) {
        NBTTagList list = new NBTTagList();
        for (TileTownHall.NpcDeathEntry entry : this.deathList) {
            list.func_74742_a((NBTBase)entry.writeToNBT(new NBTTagCompound()));
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("deathList", (NBTBase)list);
        if (!onlyDeathList) {
            tag.func_74768_a("range", ((TileTownHall)this.tileEntity).getRange());
            tag.func_74778_a("name", ((TileTownHall)this.tileEntity).name);
        }
        this.sendDataToClient(tag);
    }

    public List<TileTownHall.NpcDeathEntry> getDeathList() {
        return this.deathList;
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int slotClickedIndex) {
        ItemStack slotStackCopy = ItemStack.field_190927_a;
        Slot theSlot = this.func_75139_a(slotClickedIndex);
        if (theSlot.func_75216_d()) {
            ItemStack slotStack = theSlot.func_75211_c();
            slotStackCopy = slotStack.func_77946_l();
            IItemHandler handler = (IItemHandler)((TileTownHall)this.tileEntity).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (slotClickedIndex < handler.getSlots() ? !this.func_75135_a(slotStack, handler.getSlots(), handler.getSlots() + this.playerSlots, false) : !this.func_75135_a(slotStack, 0, handler.getSlots(), false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190916_E() == 0) {
                theSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                theSlot.func_75218_e();
            }
            if (slotStack.func_190916_E() == slotStackCopy.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            theSlot.func_190901_a(par1EntityPlayer, slotStack);
        }
        return slotStackCopy;
    }
}

