/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity;

import com.google.common.base.Predicate;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIAttackMeleeLongRange;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIAttackNearest;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIDistressResponse;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIDoor;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIFollowPlayer;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIHurt;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIMedicBase;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIMoveHome;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIWander;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIWatchClosest;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIOwnerHurtByTarget;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIOwnerHurtTarget;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedAlarmResponse;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedAttackRanged;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedCommander;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedFollowCommand;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedGetFood;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedIdleWhenHungry;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedPatrol;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedRideHorse;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.entity.RangeAttackHelper;
import net.shadowmage.ancientwarfare.npc.item.ItemCombatOrder;
import net.shadowmage.ancientwarfare.npc.item.ItemCommandBaton;

public class NpcCombat
extends NpcPlayerOwned
implements IRangedAttackMob {
    private static final String PATROL_AI_TAG = "patrolAI";
    private NpcAIAttackMeleeLongRange meleeAI = new NpcAIAttackMeleeLongRange(this);
    private EntityAIBase arrowAI = new NpcAIPlayerOwnedAttackRanged(this);
    private NpcAIPlayerOwnedPatrol patrolAI;
    private NpcBase distressedTarget;

    public NpcCombat(World par1World) {
        super(par1World);
        this.horseAI = new NpcAIPlayerOwnedRideHorse(this);
        this.patrolAI = new NpcAIPlayerOwnedPatrol(this);
        Predicate selector = this::isHostileTowards;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new NpcAIDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.horseAI);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new NpcAIPlayerOwnedFollowCommand(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new NpcAIPlayerOwnedGetFood(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new NpcAIPlayerOwnedIdleWhenHungry(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new NpcAIFollowPlayer(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new NpcAIPlayerOwnedAlarmResponse(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new NpcAIMedicBase(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new NpcAIDistressResponse(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)this.patrolAI);
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new NpcAIMoveHome(this, 50.0f, 5.0f, 20.0f, 5.0f));
        this.field_70714_bg.func_75776_a(101, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(102, (EntityAIBase)new NpcAIWander(this));
        this.field_70714_bg.func_75776_a(103, (EntityAIBase)new NpcAIWatchClosest(this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new NpcAIPlayerOwnedCommander(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new NpcAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new NpcAIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new NpcAIHurt(this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new NpcAIAttackNearest(this, (Predicate<Entity>)selector));
        this.func_98053_h(true);
    }

    protected boolean func_175448_a(ItemStack stack) {
        return this.func_184614_ca().func_190926_b() || this.func_184614_ca().func_77973_b() == stack.func_77973_b();
    }

    @Override
    public boolean isValidOrdersStack(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemCombatOrder;
    }

    @Override
    public void onOrdersInventoryChanged() {
        this.patrolAI.onOrdersInventoryChanged();
    }

    @Override
    public void onWeaponInventoryChanged() {
        super.onWeaponInventoryChanged();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a(this.arrowAI);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.meleeAI);
            ItemStack stack = this.func_184614_ca();
            if (this.isBow(stack.func_77973_b())) {
                this.field_70714_bg.func_75776_a(4, this.arrowAI);
            } else {
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.meleeAI);
            }
            if (this.meleeAI != null) {
                this.meleeAI.setAttackReachFromWeapon(this.func_184614_ca());
            }
        }
    }

    @Override
    public boolean func_70686_a(Class claz) {
        return this.isBow(this.func_184614_ca().func_77973_b()) || super.func_70686_a(claz);
    }

    @Override
    public boolean worksInRain() {
        return true;
    }

    @Override
    public boolean isPassive() {
        return false;
    }

    @Override
    public boolean shouldSleep() {
        return false;
    }

    private boolean isBow(Item item) {
        return item instanceof ItemBow;
    }

    @Override
    public String getNpcSubType() {
        return this.getSubtypeFromEquipment();
    }

    private String getSubtypeFromEquipment() {
        ItemStack stack = this.func_184614_ca();
        if (!stack.func_190926_b()) {
            Item item = stack.func_77973_b();
            Set tools = item.getToolClasses(stack);
            if (tools.contains("axe")) {
                return "medic";
            }
            if (tools.contains("hammer")) {
                return "engineer";
            }
            if (this.isBow(item)) {
                return "archer";
            }
            if (item instanceof ItemCommandBaton) {
                return "commander";
            }
            if (item.func_77616_k(stack)) {
                return "soldier";
            }
        }
        return "";
    }

    @Override
    public String getNpcType() {
        return "combat";
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.onWeaponInventoryChanged();
        if (tag.func_74764_b(PATROL_AI_TAG)) {
            this.patrolAI.readFromNBT(tag.func_74775_l(PATROL_AI_TAG));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74782_a(PATROL_AI_TAG, (NBTBase)this.patrolAI.writeToNBT(new NBTTagCompound()));
    }

    public void func_82196_d(EntityLivingBase target, float force) {
        float precision = 10.0f - (float)this.getLevelingStats().getBaseLevel() / (float)AWNPCStatics.maxNpcLevel * 10.0f;
        RangeAttackHelper.doRangedAttack((EntityLivingBase)this, target, force, precision);
    }

    public void respondToDistress(NpcBase source) {
        this.distressedTarget = source;
    }

    public NpcBase getDistressedTarget() {
        return this.distressedTarget;
    }

    public void clearDistress() {
        this.distressedTarget = null;
    }
}

