/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIDoor;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIFleeHostiles;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIFollowPlayer;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIMoveHome;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIWander;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedAlarmResponse;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedFollowCommand;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedGetFood;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedIdleWhenHungry;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedRideHorse;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedTrader;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.item.ItemCommandBaton;
import net.shadowmage.ancientwarfare.npc.item.ItemTradeOrder;
import net.shadowmage.ancientwarfare.npc.orders.TradeOrder;
import net.shadowmage.ancientwarfare.npc.trade.POTradeList;

public class NpcTrader
extends NpcPlayerOwned {
    private EntityPlayer trader;
    private POTradeList tradeList = new POTradeList();
    private NpcAIPlayerOwnedTrader tradeAI;

    public NpcTrader(World par1World) {
        super(par1World);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new NpcAIDoor((EntityLiving)this, true));
        this.horseAI = new NpcAIPlayerOwnedRideHorse(this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.horseAI);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new NpcAIFollowPlayer(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new NpcAIPlayerOwnedFollowCommand(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new NpcAIFleeHostiles(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new NpcAIPlayerOwnedAlarmResponse(this));
        this.tradeAI = new NpcAIPlayerOwnedTrader(this);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.tradeAI);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new NpcAIPlayerOwnedGetFood(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new NpcAIPlayerOwnedIdleWhenHungry(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new NpcAIMoveHome(this, 50.0f, 3.0f, 30.0f, 3.0f));
        this.field_70714_bg.func_75776_a(101, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(102, (EntityAIBase)new NpcAIWander(this));
        this.field_70714_bg.func_75776_a(103, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
    }

    @Override
    public boolean isValidOrdersStack(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemTradeOrder;
    }

    @Override
    public void onOrdersInventoryChanged() {
        this.tradeList = null;
        if (this.isValidOrdersStack(this.ordersStack)) {
            this.tradeList = TradeOrder.getTradeOrder(this.ordersStack).getTradeList();
        }
        this.tradeAI.onOrdersUpdated();
    }

    @Override
    public String getNpcSubType() {
        return "";
    }

    @Override
    public String getNpcType() {
        return "trader";
    }

    @Override
    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean baton;
        boolean bl = baton = !player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() instanceof ItemCommandBaton;
        if (baton) {
            return false;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.isOwner(player)) {
            return this.tryCommand(player);
        }
        if (this.trader != null && !this.trader.func_70089_S()) {
            this.closeTrade();
        }
        if (this.getFoodRemaining() > 0 && this.trader == null) {
            this.startTrade(player);
            this.openAltGui(player);
        }
        return true;
    }

    public void startTrade(EntityPlayer player) {
        this.trader = player;
    }

    public void closeTrade() {
        this.trader = null;
    }

    @Override
    public void openAltGui(EntityPlayer player) {
        NetworkHandler.INSTANCE.openGui(player, 47, this.func_145782_y(), 0, 0);
    }

    @Override
    public boolean hasAltGui() {
        return true;
    }

    @Override
    public boolean shouldBeAtHome() {
        return this.field_70170_p.field_73011_w.func_191066_m() && !this.field_70170_p.func_72935_r() || this.field_70170_p.func_175727_C(this.func_180425_c());
    }

    @Override
    public boolean isHostileTowards(Entity e) {
        return false;
    }

    public POTradeList getTradeList() {
        return this.tradeList;
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74782_a("tradeAI", (NBTBase)this.tradeAI.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.tradeAI.readFromNBT(tag.func_74775_l("tradeAI"));
    }
}

