/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity.faction;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.ai.faction.NpcAIFactionRideHorse;
import net.shadowmage.ancientwarfare.npc.entity.faction.IHorseMountedNpc;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.npc.entity.faction.attributes.AdditionalAttributes;

public abstract class NpcFactionMounted
extends NpcFaction
implements IHorseMountedNpc {
    private boolean horseLives = true;
    private NpcAIFactionRideHorse horseAI = new NpcAIFactionRideHorse<NpcFactionMounted>(this);

    @Override
    public boolean isHorseAlive() {
        return this.horseLives;
    }

    @Override
    public void setHorseKilled() {
        this.horseLives = false;
    }

    public NpcFactionMounted(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.horseAI);
    }

    public NpcFactionMounted(World world, String factionName) {
        super(world, factionName);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.horseAI);
    }

    @Override
    protected void func_70623_bb() {
        super.func_70623_bb();
        if (this.field_70128_L && this.func_184187_bx() instanceof EntityHorse) {
            this.func_184187_bx().func_70106_y();
            this.func_184210_p();
        }
    }

    @Override
    protected void onRepack() {
        if (this.func_184187_bx() instanceof EntityHorse) {
            this.func_184187_bx().func_70106_y();
            this.func_184210_p();
        }
    }

    @Override
    public boolean worksInRain() {
        return true;
    }

    @Override
    public boolean isPassive() {
        return false;
    }

    @Override
    public boolean shouldSleep() {
        return false;
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.horseLives = tag.func_74767_n("horseLives");
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("horseLives", this.horseLives);
    }

    @Override
    public EntityLiving instantiateMountedEntity() {
        Class<EntityHorse> clazz = this.getAdditionalAttributeValue(AdditionalAttributes.HORSE_ENTITY).orElse(EntityHorse.class);
        try {
            Constructor ctr = clazz.getConstructor(World.class);
            return (EntityLiving)ctr.newInstance(this.field_70170_p);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            AncientWarfareNPC.LOG.error("Error instantiating horse entity for class: " + clazz.toString(), (Throwable)e);
            return new EntityHorse(this.field_70170_p);
        }
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        this.horseAI.onKilled();
        super.func_70645_a(damageSource);
    }
}

