/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity.faction;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIDoor;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIFollowPlayer;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIMoveHome;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIWander;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.npc.item.ItemCommandBaton;
import net.shadowmage.ancientwarfare.npc.trade.FactionTradeList;

public class NpcFactionTrader
extends NpcFaction {
    private FactionTradeList tradeList = new FactionTradeList();
    private EntityPlayer trader;
    private boolean noTradesDespawn = false;

    public NpcFactionTrader(World world) {
        super(world);
        this.addAI();
    }

    public NpcFactionTrader(World world, String factionName) {
        super(world, factionName);
        this.addAI();
    }

    private void addAI() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new NpcAIDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new NpcAIFollowPlayer(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new NpcAIMoveHome(this, 50.0f, 5.0f, 30.0f, 5.0f));
        this.field_70714_bg.func_75776_a(101, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(102, (EntityAIBase)new NpcAIWander(this));
        this.field_70714_bg.func_75776_a(103, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
    }

    public FactionTradeList getTradeList() {
        return this.tradeList;
    }

    public void startTrade(EntityPlayer player) {
        this.trader = player;
    }

    public void closeTrade() {
        this.trader = null;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.noTradesDespawn && this.tradeList.isEmpty()) {
                this.func_70106_y();
            }
            this.tradeList.tick(this.field_70170_p);
        }
    }

    @Override
    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean baton;
        boolean bl = baton = !player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() instanceof ItemCommandBaton;
        if (!baton && this.func_70089_S()) {
            if (!player.field_70170_p.field_72995_K && this.trader == null) {
                this.startTrade(player);
                NetworkHandler.INSTANCE.openGui(player, 42, this.func_145782_y(), 0, 0);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getNpcType() {
        return "trader";
    }

    @Override
    public boolean isHostileTowards(Entity e) {
        return false;
    }

    @Override
    public boolean canTarget(Entity e) {
        return false;
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.tradeList.deserializeNBT(tag.func_74775_l("tradeList"));
        this.noTradesDespawn = true;
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74782_a("tradeList", (NBTBase)this.tradeList.serializeNBT());
    }
}

